
/*
   MiscDragView.h
   Original Authors:Todd Thomas, Bill Shirley, Bruce McKenzie,
       Steve Hayman, Daniel Boehringer.
   Rewritten by: 	Todd Thomas <tthomas@thoughtport.com>
   Began:			February 14, 1994
   Last Changed:	October 1, 1996
   Version:			2.0
   Changes:			See the end of MiscDragView.m
  		
   $Id: MiscDragView.h,v 1.2 1996/10/07 02:49:16 todd Exp $

   This object is included in the MiscKit by permission from the author
   and its use is governed by the MiscKit license, found in the file
   "LICENSE.rtf" in the MiscKit distribution.  Please refer to that file
   for a list of all applicable permissions and restrictions.

   Copyright (C) 1995, 1996 Todd Thomas
   Use is governed by the MiscKit license
*/

#import <AppKit/NSControl.h>


@interface MiscDragView : NSControl
{
    id _delegate;
}

/*" Class initialization "*/ 
+ (void) initialize;
+ (Class) cellClass;
+ (void) setCellClass:(Class)dragCellClass;

/*" Our images "*/
- (NSImage*) image;
- (void) setImage:(NSImage*)image;
- (NSImage*) acceptingImage;
- (void) setAcceptingImage: (NSImage *)anImage;
- (NSImage *) dragImage;
- (void) setDragImage: (NSImage *)anImage;

/*" Drag options "*/
- (void) setAllowsSourceDragging: (BOOL)aBool;
- (BOOL) allowsSourceDragging;
- (void) setAllowsDestinationDragging: (BOOL)aBool;
- (BOOL) allowsDestinationDragging;

- (BOOL) acceptsForeignDrag;
- (BOOL) acceptsLocalDrag;
- (BOOL) acceptsSelfDrag;
- (BOOL) retainsData;
- (BOOL) shadowsIncoming;
- (void) setShadowsIncoming:(BOOL) aBool;
- (NSColor*) shadowColor;
- (BOOL) dragImageSlidesBack;

/*" Title options "*/
- (NSString*) title;
- (void) setTitle:(NSString*)newTitle;
- (BOOL) displaysTitle;
- (void) setDisplaysTitle:(BOOL)displays;
- (BOOL) isTitleEditable;
- (void) setTitleEditable:(BOOL)isEditable;
- (BOOL) isTitleMultiline;
- (void) setTitleMultiline:(BOOL)isMultiline;

/*" Our delegate "*/
- (id) delegate;
- (void) setDelegate:(id)newDelegate;

/*" Source dragging "*/
- (void) initializeDragTypes;
		
/*" Drag helpers "*/
- (BOOL) acceptsFirstMouse:(NSEvent *)theEvent;
- (BOOL) shouldDelayWindowOrderingForEvent:(NSEvent *)theEvent;

/*" Display options "*/
- (void) setBorderType:(NSBorderType)aType;
- (NSBorderType) borderType;

/*" Archiving "*/
- (id) initWithCoder:(NSCoder *)aDecoder;
- (void) encodeWithCoder:(NSCoder *)aCoder;

@end


@interface MiscDragView (NSDraggingSource)

- (unsigned int) draggingSourceOperationMaskForLocal:(BOOL)flag;
- (void) draggedImage:(NSImage *)image endedAt:(NSPoint)screenPoint deposited:(BOOL)flag;

@end


@interface MiscDragView (NSDraggingDestination)

- (unsigned int) draggingEntered:(id <NSDraggingInfo>)sender;
- (unsigned int) draggingUpdated:(id <NSDraggingInfo>)sender;
- (void) draggingExited:(id <NSDraggingInfo>)sender;
- (BOOL) prepareForDragOperation:(id <NSDraggingInfo>)sender;
- (BOOL) performDragOperation:(id <NSDraggingInfo>)sender;
- (void) concludeDragOperation:(id <NSDraggingInfo>)sender;

@end


@interface NSObject (MiscDragViewDelegate)

- (void) didInitiateSourceDrag:sender;
- (void) didFinishSourceDrag:(BOOL)successful;
- (void) didInitiateDestinationDrag:sender;
- (void) didFinishDestinationDrag:(BOOL)successful;
- (void) initDragTypes:sender;
- (void) prepareForSourceDrag:sender;
- (NSImage*) image;
- (NSImage*) acceptingImage;
- (BOOL) takeDataFromPasteboard:sender;

@end

