/*	MiscHitPath.h

	Copyright 1996 Uwe Hoffmann.

	This notice may not be removed from this source code.
	The use and distribution of this software is governed by the
	terms of the MiscKit license agreement.  Refer to the license
	document included with the MiscKit distribution for the terms.

	Version 2 (August 1996)
*/

#import "MiscUserPath.h"

@interface MiscHitPath:MiscUserPath
{
    float hitWidth;	/*"Width of the hit detection square"*/
}

/*"Allocating and initializing"*/
- initWithWidth:(float)width;

/*"Hit detection"*/
- (BOOL)hit:(int)op path:(MiscUserPath *)aPath;

/*"Manipulating hit path"*/
- (void)moveTo:(NSPoint)p;
- (void)scaleWith:(float)aScale;
- (float)width;
- (void)setWidth:(float)width;

@end
