/*	MiscRubberband.h

	Copyright 1996 Slugg Jello.

	This notice may not be removed from this source code.
	The use and distribution of this software is governed by the
	terms of the MiscKit license agreement.  Refer to the license
	document included with the MiscKit distribution for the terms.

	Converted to OpenStep, August 1996, Uwe Hoffmann.
*/

#import <AppKit/AppKit.h>

/*" This types constants define the pivot position 
when stretching the rubberband."*/
typedef enum {
	MiscCornerPivot,
	MiscCenterPivot
} MiscPivotType;

@interface MiscRubberband:NSObject
{
@private
	NSRect currentRect;				/*"rubberband rect"*/ 
	NSRect boundsRect;				/*"stretching bounds for rubberband"*/
	NSView *view;					/*"associated view"*/
	MiscPivotType pivot;				/*"pivot type"*/
	struct {
		unsigned char inclusive:1;		/*"rect inclusive rubberband ?"*/
		unsigned char usesBounds:1;		/*"uses bounds when stretching rubberband"*/
	} flags;
}

/*"Allocating and initializing an MiscRubberband instance"*/
+ rubberbandWithView:(NSView *)aView;
- initWithView:(NSView *)aView;

/*"Stretching"*/
- (void)doStretch:(NSEvent *)event;

/*"Accessing and setting associated view"*/
- (void)setView:(NSView *)aView;
- (NSView *)view;

/*"Accessing and setting pivot type"*/
- (void)setPivot:(MiscPivotType)aPivot;
- (MiscPivotType)pivot;

/*"Accessing and setting geometric structure"*/
- (NSRect)bounds;
- (NSRect)currentRect;
- (BOOL)inclusive;
- (void)setInclusive:(BOOL)aBool;
- (BOOL)usesBounds;
- (void)setUsesBounds:(BOOL)aBool;
- (void)setBounds:(NSRect)bounds;
- (void)setCurrentRectToBounds;
 
@end
