/* MiscSwapViewItem.h				 
 *
 *
 * Written by: 		Thomas Engel
 * Created:    		24.01.1994 (Copyright 1994 Thomas Engel)
 * Last Modified: 	14.02.1994
 */

//	This object is included in the MiscKit by permission from the author
//	and its use is governed by the MiscKit license, found in the file
//	"LICENSE.rtf" in the MiscKit distribution.  Please refer to that file
//	for a list of all applicable permissions and restrictions.

/*"
    If the notification tell us the we are about to get deselected then we will send ouself an <B>ok:</B> message with sender set to self. You usually subclass <B>ok:</B> and not this notification.
"*/
/*" @References: ok:
"*/

#import <AppKit/AppKit.h>

@class MiscSwapView;

@interface MiscSwapViewItem : NSObject
/*"
    A very simple class for controlling swapAble views. A subclass is a must to easily work with the MiscSwapView classes.

    Just create a instance and connect it to the view that holds the should swap in when the identifier object is activated. As an alternative you can set the tag this view is related to by creating an object with the right tag and setting it to be theidentifier. Its very easy to do this with the IB.
"*/
{
	id		swapView;				// propably only needed for IB work and might go away in the future
	id		view;					// the view that will be swapped into the swapView
	id		identifier;				// the identifier that is matched prior to swapping
	int		tag;					// tag to compare with identifier's tag
    id		initialFirstResponder;  // Not used yet :-( 
}

+ (void)initialize;
- (id)init;
- (id)initWithIdentifier:(id)anObject;
- (void)dealloc;

- (id)initWithCoder:(NSCoder *)aDecoder;
- (void)encodeWithCoder:(NSCoder *)aCoder;

- (void)setView:(NSView *)aView;
- (NSView *)view;
- (void)setInitialFirstResponder:(NSView *)aView;
- (id)initialFirstResponder;

- (void)setIdentifier:(id)anObject;
- (id)identifier;
- (void)setTag:(int)anInt;
- (int)tag;
- (BOOL)matchesIdentifier:(id)anObject comparingTags:(BOOL)flag;

// Preparing for display

- (void)ok:(id)sender;
- (void)revert:(id)sender;

// Notifications...we only have a predefined way of handlign these

- (void)swapViewItemWillGetSelected:(NSNotification *)notification;
- (void)swapViewItemWillGetDeselected:(NSNotification *)notification;

@end


@interface MiscSwapViewItem (IBHelperMethods)

// <<NOTE>> The swapView method is not very nice since its not really necessary to keep that ref.
// This is a hack so that the interface can be hooked up a lot easier insde IB.
// If we find a reason to really keep this method around it will be move into the regular set...
// Until then...don't use it since it migth go away.

- (void)setSwapView:(MiscSwapView *)aView;
- (MiscSwapView *)swapView;

@end


/*
 * History: 	29.06.97 Ported it to OPENSTEP. Switched to identifier and changed the name to MiscSwapViewItem
 *
 *		14.02.94 Changed the classes name to MiscSwapContentsController
 *					 from the MiscSwapSubviewController becauses it fits better
 *					 to what it really is.
 *
 *		24.01.94 Made it a Misc object and changed it to work with the
 *					 new Misc stuff.
 *
 *		09.01.94 Added the ok/revert stuff.
 *
 *		08.01.94 Derived from my old swapViewdelegate. The code+methods
 *					 were cleaned up a bit.
 *
 *
 * Bugs: - No read/write.
 *
 *		 - I could have automated the colorWell 'problem' but I don't think it
 *		   would be a good idea. It's not only a colorWell problem.
 *		   Swapping out has some affect on EVERY object that is linked to the 
 *		   outside world.
 *		   A buildin soultion can not handle every case where object will be
 *		   linked to the outside world.
 *		   ( I thank the guys form UNInspector Kit because they made the 
 *			 notice that problem through their release notes. Anyway I think
 *			 this kit has a more general approach towards inspectors. )
 */