/*	MiscTreeDiagram.h

	Copyright 1996 Uwe Hoffmann.

	This notice may not be removed from this source code.
	The use and distribution of this software is governed by the
	terms of the MiscKit license agreement.  Refer to the license
	document included with the MiscKit distribution for the terms.

	Version 2 (August 1996)
*/

#import <Foundation/NSObject.h>

#import "MiscTDDocAPI.h"
#import <MiscFoundation/MiscLayoutTree.h>
#import "MiscDiagramShape.h"
#import "MiscTreeStyle.h"
#import "MiscNodeStyle.h"

@class MiscDiagramTree, MiscUserPath, MiscHitPath, MiscUndoManager, MiscTreeDiagramView;

@interface MiscTreeDiagram:NSObject <NSCoding>
{
@private
	MiscDiagramTree *tree, *selectedNode;
	MiscTreeStyle *style;
	MiscTreeDiagramView *view;
	id <MiscTDDocAPI> doc;
	NSPrintInfo *printInfo;
	int editMode;
        MiscUndoManager *undoManager;
}

/*"Allocating and initializing an MiscTreeDiagram instance"*/
- initWithTreeStyle:(MiscTreeStyle *)aStyle;

/*"Setting and accessing root of diagram"*/
- (MiscDiagramTree *)root;
- (void)setRoot:(MiscDiagramTree *)aTree;

/*"Adding, rearranging and deleting nodes"*/
- (void)addChildToSelected:(MiscDiagramTree *)aChild;
- (void)addNewChildToSelected;
- (void)deleteSelected;
- (void)addChild:(MiscDiagramTree *)aChild to:(MiscDiagramTree *)aNode;
- (void)addChild:(MiscDiagramTree *)aChild to:(MiscDiagramTree *)aNode atIndex:(unsigned)anIndex;
- (void)deleteNode:(MiscDiagramTree *)aNode;
- (void)rearrangeChild:(MiscDiagramTree *)aChild toIndex:(unsigned)anIndex;

/*"Manipulating selection"*/
- (MiscDiagramTree *)selectedNode;
- (void)selectNode:(MiscDiagramTree *)aNode;
- (void)unselectSelected;
- (MiscDiagramTree *)selectNodeWithHitPath:(MiscHitPath *)aPath
  controlPoint:(int *)aInt;
- (void)selectNextSibling;
- (void)selectPreviousSibling;
- (void)selectChild;
- (void)selectParent;

/*"Support for dragging"*/
- (MiscDiagramTree *)acceptsDraggingWithHitPath:(MiscHitPath *)aPath
   onOutline:(BOOL *)onOutline;

/*"Manipulating node style"*/
- (void)setNodeStyle:(MiscNodeStyle *)aStyle of:(MiscDiagramTree *)aNode;
- (void)setFillColor:(NSColor *)aColor of:(MiscDiagramTree *)aNode;
- (void)setOutlineColor:(NSColor *)aColor of:(MiscDiagramTree *)aNode;
- (void)setLinewidth:(float)aLinewidth of:(MiscDiagramTree *)aNode;
- (void)setShapeType:(MiscShapeType)aShapeType of:(MiscDiagramTree *)aNode;
- (void)setParentEnding:(MiscEndingType)anEnding of:(MiscDiagramTree *)aNode;
- (void)setChildEnding:(MiscEndingType)anEnding of:(MiscDiagramTree *)aNode;
- (void)toggleCollapseNode:(MiscDiagramTree *)aNode;
- (void)setSize:(NSSize)aSize of:(MiscDiagramTree *)aNode;
- (void)setTextPlacement:(MiscTextPlacement)aTextPlacement of:(MiscDiagramTree *)aNode;
- (void)setAutomaticResize:(BOOL)aBool of:(MiscDiagramTree *)aNode;

/*"Manipulating node contents"*/
- (void)setLabel:(NSAttributedString *)aLabel of:(MiscDiagramTree *)aNode;

/*"Manipulating tree style"*/
- (void)setDistanceToParent:(float)aDistance;
- (void)setBorder:(float)aBorder;
- (void)setLineType:(MiscLineType)aType;
- (void)setBendingFactor:(float)aFactor;
- (void)setLayoutType:(MiscLayoutTreeType)aType;
- (void)setShadow:(BOOL)aBool;
- (void)setShadowColor:(NSColor *)aColor;
- (MiscTreeStyle *)treeStyle;
- (void)setTreeStyle:(MiscTreeStyle *)aStyle;

/*"Setting and accessing associated view instance"*/
- (MiscTreeDiagramView *)view;
- (void)setView:(MiscTreeDiagramView *)aView;

/*"Accessing undo manager"*/
- (MiscUndoManager *)undoManager;

/*"Editing diagram"*/
- (void)beginEditing;
- (void)endEditing;

/*"Setting and accessing associated doc instance"*/
- (void)setDoc:(id <MiscTDDocAPI>)aDoc;
- (id <MiscTDDocAPI>)doc;

/*"Accessing printinfo object"*/
- (NSPrintInfo *)printInfo;

@end
