/*	MiscTreeDiagramView.h

	Copyright 1996 Uwe Hoffmann.

	This notice may not be removed from this source code.
	The use and distribution of this software is governed by the
	terms of the MiscKit license agreement.  Refer to the license
	document included with the MiscKit distribution for the terms.

	Version 2 (August 1996)
*/

#import <AppKit/AppKit.h>
#import <Foundation/Foundation.h>

#import "MiscZooming.h"

#import "MiscDiagramTree.h"	

#define MISCTDV_REPAINT_NORMAL	1
#define MISCTDV_REPAINT_EVENT	2

extern NSString *MiscTreeDiagramPboardType;
extern NSString *MiscTreeDiagramStylePboardType;

typedef enum {
	MiscEditMode,
	MiscPresentationMode,
	MiscPaletteMode
} MiscTreeViewOperationMode;

@class MiscTreeDiagram, MiscUserPath, MiscHitPath, MiscDiagramTree;

@interface MiscTreeDiagramView:NSView <MiscZooming>
{
@private
	MiscTreeDiagram *treeDiagram;
	MiscUserPath *linePath, *canvasPath;
	MiscHitPath *hitPath;
	BOOL isOwnerOfDiagram;
	NSRect canvasRect;
	int canvasXTimes, canvasYTimes;
	NSMutableArray *nodes;
	MiscDrawState drawState;
	BOOL showAttachments;
	int repaintMode;
	NSImage *buffer;
        float zoomFactor;
	struct {
		MiscDiagramTree *node;
		NSRect textFrame;
	} labelEditingTempData;
	NSColor *bgColor;
	struct {
		unsigned char selectable:1;
		unsigned char editable:1;
		unsigned char changeable:1;
		unsigned char dragSource:1;
		unsigned char dragDest:1;
	} opFlags;
	MiscTreeViewOperationMode opMode;
	id paletteControl;	
}

- initWithFrame:(NSRect)frameRect treeDiagram:(MiscTreeDiagram *)aDiagram;

- (MiscTreeDiagram *)diagram;
- (void)setDiagram:(MiscTreeDiagram *)diagram;

- (BOOL)writeDiagramToFile:(NSString *)path;
- (BOOL)readDiagramFromFile:(NSString *)path;

- (BOOL)writeDiagramToDGFile:(NSString *)path;

- (int)canvasWidthNumberOfPages;
- (int)canvasHeightNumberOfPages;

- (void)setEditable:(BOOL)aBool;
- (BOOL)isEditable;
- (void)setSelectable:(BOOL)aBool;
- (BOOL)isSelectable;
- (void)setDragSource:(BOOL)aBool;
- (BOOL)isDragSource;
- (void)setDragDestination:(BOOL)aBool;
- (BOOL)isDragDestination;
- (MiscTreeViewOperationMode)operationMode;
- (void)setOperationMode:(MiscTreeViewOperationMode)aMode;

- (NSColor *)backgroundColor;
- (void)setBackgroundColor:(NSColor *)aColor;

@end

@interface MiscTreeDiagramView(Dragging)

+ (void)pasteboard:(NSPasteboard *)pb provideDataForType:(NSString *)type;
- (unsigned int)draggingEntered:sender;
- (unsigned int)draggingUpdated:sender;
- (BOOL)performDragOperation:sender;
- (void)draggedImage:(NSImage *)image beganAt:(NSPoint)screenPoint;
- (unsigned int)draggingSourceOperationMaskForLocal:(BOOL)flag;
- (void)draggedImage:(NSImage *)image endedAt:(NSPoint)screenPoint deposited:(BOOL)flag;

@end

@interface MiscTreeDiagramView(TargetAction)

- (void)cut:(id)sender;
- (void)paste:(id)sender;
- (void)delete:(id)sender;
- (void)copy:(id)sender;

- (void)undo:(id)sender;
- (void)redo:(id)sender;
- (void)freeUndoBuffer:(id)sender;

- (void)copyStyle:(id)sender;
- (void)pasteStyle:(id)sender;
- (void)promoteStyle:(id)sender;

- (void)pageLayout:(id)sender;

- (void)collapseExpand:(id)sender;

- (void)toggleRuler:(id)sender;
- (void)toggleAttachments:(id)sender;

- (void)findNext:(id)sender;
- (void)findPrevious:(id)sender;
- (void)findNextAndOrderFindPanelOut:(id)sender;
- (void)replace:(id)sender;
- (void)replaceAndFind:(id)sender;
- (void)replaceAll:(id)sender;
- (void)orderFrontFindPanel:(id)sender;

- (BOOL)validateMenuItem:(NSMenuItem *)anItem;

@end
	