/*	MiscUserPath.h

	Copyright 1996 Uwe Hoffmann.

	This notice may not be removed from this source code.
	The use and distribution of this software is governed by the
	terms of the MiscKit license agreement.  Refer to the license
	document included with the MiscKit distribution for the terms.

	Version 2 (August 1996)
*/

#import <Foundation/NSObject.h>
#import <Foundation/NSGeometry.h>


@interface MiscUserPath:NSObject <NSCopying, NSCoding>
{
    unsigned int maxLengthParams;		/*"Size of operand array."*/
    unsigned int maxLengthOps;			/*"Size of operator array."*/
    BOOL ping;					/*"True if calling NSPing() after sending path to window server."*/
    float *bboxParams;				/*"Pointer to operand+bounding box array."*/
    float *bbox;				/*"Pointer to bounding box (bbox  == bboxParams)."*/
    float *params;				/*"Pointer to operand array (params == &bboxParams [4])."*/
    unsigned int lengthParams;			/*"Size of operand fill."*/
    unsigned int lengthOps;			/*"Size of operator fill."*/
    char *ops;					/*"Pointer to operator array (ops == &bboxOps[2])."*/
    char *bboxOps;				/*"Pointer to operator+bounding box operators array."*/
    NSPoint cp;  				/*"Current point."*/
}

/*"Allocating and initializing"*/
- initCountParams:(int)numParams countOps:(int)numOps;

/*"Accessing instance variables"*/
- (NSRect)bounds;
- (NSPoint)currentPoint;
- (void)setCurrentPoint:(NSPoint)aPoint;
- (float *)params;
- (float *)bbox;
- (float *)bboxParams;
- (char *)ops;
- (char *)bboxOps;
- (unsigned int)lengthParams;
- (unsigned int)lengthOps;
- (unsigned int)maxLengthParams;
- (unsigned int)maxLengthOps;
- (void)increaseLengthParamsBy:(unsigned int)extraLength;
- (void)increaseLengthOpsBy:(unsigned int)extraLength;
- (void)doubleLengthParams;
- (void)doubleLengthOps;
- (void)setLengthParams:(unsigned int)length;
- (void)setLengthOps:(unsigned int)length;
- (void)setMaxLengthParams:(unsigned int)length;
- (void)setMaxLengthOps:(unsigned int)length;

/*"Defining user path"*/
- (void)resetFill;
- (void)moveto:(float)x :(float)y;
- (void)rmoveto:(float)x :(float)y;
- (void)lineto:(float)x :(float)y;
- (void)rlineto:(float)x :(float)y;
- (void)curveto:(float)x1 :(float)y1 :(float)x2 :(float)y2 :(float)x3 :(float)y3;
- (void)rcurveto:(float)dx1 :(float)dy1 :(float)dx2 :(float)dy2 :(float)dx3 :(float)dy3;
- (void)arc:(float)x :(float)y :(float)r :(float)ang1 :(float)ang2;
- (void)arcn:(float)x :(float)y :(float)r :(float)ang1 :(float)ang2;
- (void)arct:(float)x1 :(float)y1 :(float)x2 :(float)y2 :(float)r;
- (void)closepath;

/*"Sending to window server"*/
- (void)debugSend:(int)op cached:(BOOL)cache;
- (void)send:(int)op cached:(BOOL)cache;

@end
