/*====================== MiscPlanetCoordConverter.h =========================*/
/* MiscPlanetCoordConverter class supports the calculations required for
   converting between World and Universal Transverse Mercator coordinates.

   DMA Release 0.8, Copyright @1993 by Genesis Project, Ltd. All Rights
   Reserved. For further information on terms and conditions see
		the MiscKit license.

HISTORY
12-Mar-93  Dale Amon at GPL
	   Split UTMGrid into constants and converter parts.
22-Feb-93  Dale Amon at GPL
	   Created.
*/

#import <Foundation/Foundation.h>
#import <MiscFoundation/MiscCoordConverter.h>

@class MiscUTMConstants;

#define	MISC_PLANET_CONVERT_VERSION_ID	0.8

@interface MiscPlanetCoordConverter:MiscCoordConverter
{	MiscUTMConstants	*xlate;		/* where to find the conversion
					   constants */

	/* blackboard for temporary calculations */
	double	sinPhi,sin2Phi;
	double	rho;
	double	nu;
	double	etaSqrd;
	double	M;
}

+ (void)initialize;
+ new;
- awakeAfterUsingCoder:(NSCoder *)aDecoder;

/* exported ONLY for use in writing modified UTM's. I'd actually prefer
   not to do this at all...
*/
- (void) blackboardCalc: (double) phi;
- (double) calcM: (double) phi;
- (double) calcPhiPrime: (double) N;
+ superalloc;

/* These are overridden to block their use */
+ alloc;
+ allocWithZone:(NSZone *)zone;
- (void)dealloc;

@end
