/*========================= MiscSphericalCoord.h ============================*/
/* MiscSphericalCoord class contains and supports values representing locations
   in a Spherical coordinate system. Angles are stored internally as radians
   at all times, but may be stored or retrieved as degrees.

   DMA Release 0.8, Copyright @1993 by Genesis Project, Ltd. All Rights
   Reserved. For further information on terms and conditions see
		the MiscKit license.

HISTORY
25-Feb-93  Dale Amon at GPL
	   Created.
*/

#import <Foundation/Foundation.h>
#import <MiscFoundation/MiscMathCoord.h>

/* ordering of coordinates in storage */
#define MISC_PHI_SPHERE	0	/* angle in yz plane */
#define MISC_THETA_SPHERE	1	/* angle in xy plane */
#define MISC_RHO_SPHERE	2	/* radius of sphere */

@interface MiscSphericalCoord:MiscMathCoord
{

}

- setCoordPhiDegrees: (double) phi
       thetaDegrees: (double) theta
		rho: (double) rho;

- setCoordPhiRadians: (double) phi
       thetaRadians: (double) theta
		rho: (double) rho;

- coordPhiDegrees: (double*) phi
    thetaDegrees: (double*) theta
	     rho: (double*) rho;

- coordPhiRadians: (double*) phi
    thetaRadians: (double*) theta
	     rho: (double*) rho;

- (double) phiRadians;
- (double) phiDegrees;
- (double) thetaRadians;
- (double) thetaDegrees;
- (double) rho;

@end
