
//  Donated by Henry Krempel <krempel@chezhank.com>


#import <Foundation/Foundation.h>
@interface NSDictionary(WriteCopy)

/*
 * This method returns a mutable dictionary containing mutable objects
 * for all contained objects that respond to deepMutableCopyWithZone:
 * or  mutableCopyFromZone:
 */
- (NSMutableDictionary *)deepMutableCopyWithZone:(NSZone *)zone;
- (NSMutableDictionary *)deepMutableCopy;

@end

@interface NSArray(WriteCopy)

/*
 * This method returns a mutable array containing mutable objects
 * for all contained objects that respond to deepMutableCopyWithZone:
 * or  mutableCopyFromZone:
 */
- deepMutableCopyWithZone:(NSZone *)zone;
- deepMutableCopy;

@end