/* MLMarqueeView.m created by mlaster on Sat 10-Jul-1999 */

#import "WindowController.h"
#import "MLMarqueeView.h"

#import <AppKit/NSClipView.h>
#import <AppKit/NSStringDrawing.h>
#import <AppKit/NSTextStorage.h>
#import <AppKit/NSTextView.h>

#import "NSUserDefaults+ColorExtensions.h"

@implementation MLMarqueeView

- (void) dealloc
{
    [attributedString release];
    [super dealloc];
}

- (void) awakeFromNib
{
    NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
    NSTextView *aTextView = nil;

    inMenuBar = [userDefaults boolForKey: @"DisplayInMenuBar"];

    [self setPixelsPerCycle: [userDefaults integerForKey: @"PixelsPerFrame"]];
    [self setAnimationPeriod:[userDefaults floatForKey: @"FramePeriod"]];

    baseFont = [[WindowController baseFont] retain];
    
    if (inMenuBar == YES)
        [self setBackgroundColor:[userDefaults colorForKey: @"TickerMenuBackgroundColor"]];
    else
        [self setBackgroundColor:[userDefaults colorForKey: @"TickerBackgroundColor"]];

    [[self contentView] setFrameSize:NSMakeSize(1.0e7,[self frame].size.height)];
    [[self contentView] setAutoresizesSubviews:NO];

    aTextView = [[NSTextView alloc] initWithFrame:NSMakeRect(0,0,1.0e7,[self frame].size.height)];

    // configure NSTextView to our needs
    [aTextView setEditable:NO];
    [aTextView setSelectable:YES];
    [aTextView setDrawsBackground:YES];
    [aTextView setBackgroundColor:[self backgroundColor]];
    [aTextView setHorizontallyResizable:NO];
    [aTextView setVerticallyResizable:NO];
    [aTextView setRichText:YES];
    [aTextView setDelegate:self];
    [aTextView setFont: baseFont];
    [self setDocumentView:aTextView];
    [aTextView release];

    // start scroll timer
    [NSTimer scheduledTimerWithTimeInterval:period
                                     target:self
                                   selector:@selector(_timerTick:)
                                   userInfo:nil
                                    repeats:NO];

}

// recalculate display string if the window resizes
- (void) resizeWithOldSuperviewSize:(NSSize)oldFrameSize
{
    [super resizeWithOldSuperviewSize:oldFrameSize];
    if (attributedString != nil)
    {
        [self setAttributedString:attributedString];
    }
}

- (void) _timerTick:(NSTimer *)aTimer
{
    NSWindow *myWindow = [self window];
    if (attributedString != nil)
    {
        [myWindow disableFlushWindow];
        [[self contentView] scrollToPoint:NSMakePoint(offset,0)];
        [myWindow enableFlushWindow];
        [self display];
        [myWindow flushWindow];
        offset+=pixelShift;
        if (offset > maxOffset)
        {
            offset = 0;
        }
    }
    [NSTimer scheduledTimerWithTimeInterval:period
                                     target:self
                                   selector:_cmd
                                   userInfo:[aTimer userInfo]
                                    repeats:NO];
}

- (void) setAttributedString:(NSAttributedString *)aString
{
    float viewWidth = 0.0;
    float stringWidth = 0.0;
    unsigned i=0;
    unsigned multiplier = 0;
    NSMutableAttributedString *workString = nil;
    maxOffset = 0;

    NSAssert(aString != nil, @"attributedString must be non-nil!");
    [aString retain];
    [attributedString release];
    attributedString = aString;
    viewWidth = [self frame].size.width;
    stringWidth = [aString size].width;
    workString = [aString mutableCopy];
    multiplier = floor((viewWidth / stringWidth) +1 );
    for (i=0;i<multiplier;i++)
    {
        [[workString mutableString] appendString:@"   "];
        if (maxOffset == 0)
        {
            maxOffset = [workString size].width;
        }
        [workString appendAttributedString:aString];
    }

    [[[self documentView] textStorage] setAttributedString:workString];
    [workString release];
    [self setNeedsDisplay: YES];
    [[self documentView] setNeedsDisplay: YES];
    [[self superview] setNeedsDisplay: YES];
    [[self window] setViewsNeedDisplay: YES];
}

- (NSColor *) backgroundColor
{
    return backgroundColor;
}

- (void) setBackgroundColor:(NSColor *)aColor
{
    [aColor retain];
    [backgroundColor release];
    backgroundColor = aColor;
}

- (unsigned) pixelsPerCycle
{
    return pixelShift;
}

- (void) setPixelsPerCycle:(unsigned) pixels
{
    NSAssert(pixels > 0, @"Pixels must be > 1!");
    pixelShift = pixels;
}

- (NSTimeInterval) animationPeriod
{
    return period;
}

- (void) setAnimationPeriod:(NSTimeInterval)aTimeInterval
{
    period = aTimeInterval;
}

- (BOOL)textView:(NSTextView *)textView clickedOnLink:(id)link atIndex:(unsigned)charIndex
{
    NSString	*string;
    NSString	*path;
    static int	counter = 0;

    if (counter)
    {
        path = [NSTemporaryDirectory() stringByAppendingPathComponent: [NSString stringWithFormat:@"StockTrackerToWebBrowser%i.html", counter]];
        [[NSFileManager defaultManager] removeFileAtPath: path
                                                 handler: nil];
    }
    path = [NSTemporaryDirectory() stringByAppendingPathComponent: [NSString stringWithFormat:@"StockTrackerToWebBrowser%i.html", counter]];
    string = [NSString stringWithFormat: @"<html><head><meta http-equiv=\"refresh\" content=\"0 ;URL=%@\"></head></html>\r\n", link];
    if ([string writeToFile: path
                 atomically: YES])
    {
        if ([[NSWorkspace sharedWorkspace] openFile: path])
        {
            counter++;
            return YES;
        }
    }
    return NO;
}


@end
