/* NSBundle+BundleSearching.m created by mlaster on Thu 15-Jul-1999 */

#import "NSBundle+BundleSearching.h"

@implementation NSBundle(BundleSearching)

+ (NSArray *) availableBundlesOfType:(NSString *)aType
{
    int i=0;
    NSArray *searchPaths = nil;
    NSMutableArray *workPaths = nil;
    NSMutableSet *bundles = nil;
    NSArray *retValue = nil;
    
    workPaths = [[NSMutableArray alloc] init];
    [workPaths addObjectsFromArray:[[NSBundle mainBundle] pathsForResourcesOfType:aType inDirectory:nil]];
    searchPaths = NSSearchPathForDirectoriesInDomains(NSLibraryDirectory,NSAllDomainsMask,YES);
    for (i=0;i<[searchPaths count];i++)
    {
        [workPaths addObjectsFromArray:[[NSBundle bundleWithPath:[searchPaths objectAtIndex:i]] pathsForResourcesOfType:aType inDirectory:[[NSProcessInfo processInfo] processName]] ];
    }

    bundles = [[NSMutableArray alloc] init];
    for (i=0;i<[workPaths count];i++)
    {
        [bundles addObject:[NSBundle bundleWithPath:[workPaths objectAtIndex:i]]];
    }
    retValue = [bundles autorelease];
    [workPaths release];
    // we can't convert this to an NSArray because NSBundle doesn't understand copyWithZone:
    return (NSArray *)bundles;
}

- (void) setInfoDictionary:(NSDictionary *)aDictionary
{
    [aDictionary retain];
    [_infoDictionary release];
    _infoDictionary = aDictionary;
}

- (BOOL) smartLoad
{
#ifdef DEBUG
    NSMutableDictionary *infoDict = nil;
    NSString *execPath = nil;
    infoDict = [[self infoDictionary] mutableCopy];
    execPath = [[self bundlePath] stringByAppendingPathComponent:[infoDict objectForKey:@"NSExecutable"]];
    execPath = [NSString stringWithFormat:@"%@_debug", execPath];
    if ([[NSFileManager defaultManager] fileExistsAtPath:execPath] == YES)
    {
        execPath = [NSString stringWithFormat:@"%@_debug", [infoDict objectForKey:@"NSExecutable"]];
        [infoDict setObject:execPath forKey:@"NSExecutable"];
        [self setInfoDictionary:infoDict];
        [infoDict release];
    }
#endif
    return [self load];
}
@end
