/* NSNumber+FractionExtensions.m created by mlaster on Sat 10-Jul-1999 */

#import "NSNumber+FractionExtensions.h"

@implementation NSNumber(FractionExtensions)
- (unsigned) greatestCommonFactorOf:(unsigned) x and:(unsigned)y
{
    unsigned i=0;
    unsigned max=MIN(x,y);
    unsigned gcf=1;

    for(i=max;i>1;i--)
    {
        if ((x % i) == 0 && (y % i) == 0)
        {
            gcf = i;
            break;
        }
    }
    return gcf;
}

- (NSAttributedString *) fractionalRepresentation: (BOOL) useSuperSub withFont: (NSFont *) baseFont;
{
    NSMutableAttributedString *attrString = nil;
    NSScanner *aScanner = nil;
    NSString *workString = nil;
    unsigned whole = 0;
    unsigned numerator = 0;
    unsigned denominator = 0;
    unsigned gcf = 0;
    unsigned int i=0;
    NSFont *superSubFont = nil;
    NSDictionary *superFontAttributes;
    NSDictionary *subFontAttributes;
    NSDictionary *slashFontAttributes;
    NSDictionary *normalFontAttributes;

    if (useSuperSub == YES)
    {
        superSubFont = [[NSFontManager sharedFontManager] convertFont:baseFont toSize: ([baseFont pointSize] * 0.8)];
        // superSubFont = [[NSFontManager sharedFontManager] convertFont:superSubFont toHaveTrait: NSBoldFontMask]; // doesn't take, anyway-- i don't know why.
        // [workString addAttribute: NSBaselineOffsetAttributeName value: [NSNumber numberWithInt: 10] range: NSMakeRange(0, [workString length])];

        superFontAttributes = [NSDictionary dictionaryWithObjectsAndKeys: [NSNumber numberWithInt: 2], NSBaselineOffsetAttributeName, superSubFont, NSFontAttributeName, nil, nil];
        subFontAttributes = [NSDictionary dictionaryWithObjectsAndKeys: [NSNumber numberWithInt: -2], NSBaselineOffsetAttributeName, superSubFont, NSFontAttributeName, nil, nil];
        slashFontAttributes = [NSDictionary dictionaryWithObjectsAndKeys: superSubFont, NSFontAttributeName, nil, nil];
        normalFontAttributes = [NSDictionary dictionaryWithObject: baseFont forKey: NSFontAttributeName];
    } else {
        superSubFont = nil;
        superFontAttributes = nil;
        subFontAttributes = nil;
        slashFontAttributes = nil;
        normalFontAttributes = nil;
    }
    
    aScanner = [[NSScanner alloc] initWithString:[self description]];
    [aScanner scanUpToString:@"." intoString:&workString];
    whole = [workString intValue];
    workString = nil;
    [aScanner setCharactersToBeSkipped:[NSCharacterSet punctuationCharacterSet]];
    [aScanner scanUpToString:@" " intoString:&workString];
    numerator = [workString intValue];
    if (numerator != 0)
    {
        denominator=1;
        for (i=0;i<[workString length];i++)
        {
            denominator=denominator*10;
        }
    }
    gcf = [self greatestCommonFactorOf:numerator and:denominator];
    numerator = numerator / gcf;
    denominator = denominator / gcf;

    attrString = [[NSMutableAttributedString alloc] initWithString:@""];
    if (whole != 0)
    {
        [[attrString mutableString] appendString:[NSString stringWithFormat:@"%u", abs(whole)]];
    }

    if (useSuperSub == YES) {
        NSRange headRange = NSMakeRange(0,[attrString length]);
        [attrString setAttributes: normalFontAttributes range: headRange];
//        [attrString unscriptRange:headRange];
    }

    if (numerator != 0 && denominator != 0)
    {
        workString = [NSString stringWithFormat:@"%u", numerator];

        [[attrString mutableString] appendString:workString];

        if (useSuperSub == YES) {
            NSRange superRange = NSMakeRange([attrString length]-[workString length],[workString length]);
            [attrString setAttributes: superFontAttributes range: superRange];
        }

        workString = @"/";
        [[attrString mutableString] appendString:workString];
        if (useSuperSub == YES) {
            NSRange slashRange = NSMakeRange([attrString length]-[workString length],[workString length]);
            [attrString setAttributes: slashFontAttributes range: slashRange];
        }

        workString = [NSString stringWithFormat:@"%u", denominator];
        [[attrString mutableString] appendString:workString];

        if (useSuperSub == YES) {
            NSRange subRange = NSMakeRange([attrString length]-[workString length],[workString length]);
            [attrString setAttributes: subFontAttributes range: subRange];
       }
        
        // trailing space is required so we have something to attach the unscriptRange to
        [[attrString mutableString] appendString:@" "];

        if (useSuperSub == YES) {
            NSRange undoRange = NSMakeRange([attrString length]-1, 1);
            [attrString setAttributes: normalFontAttributes range: undoRange];
        }
    } else
        [[attrString mutableString] appendString:@" "];
    
    return [attrString autorelease];
}

- (NSAttributedString *) signedFractionalRepresentation: (BOOL) useSuperSub withFont: (NSFont *) baseFont;
{
    NSMutableAttributedString *workString = nil;
    NSAttributedString *returnValue = nil;
    
//!    workString = [[self fractionalRepresentation] mutableCopy];
    if ([self floatValue] >= 0)
    {
        workString = [[NSMutableAttributedString alloc] initWithString:
            [NSString stringWithFormat:@"+"]];
    }
    else
    {
        workString = [[NSMutableAttributedString alloc] initWithString:
            [NSString stringWithFormat:@"-"]];
    }
    [workString appendAttributedString:[self fractionalRepresentation: useSuperSub withFont: baseFont]];
    returnValue = [[workString copy] autorelease];
    [workString release];
    return returnValue;
}

- (NSAttributedString *) attributedDescriptionWithFormat: (NSNumberFormatter *) aFormatter withFont: (NSFont *) baseFont;
{
    NSMutableAttributedString *workString = [[[aFormatter attributedStringForObjectValue: self withDefaultAttributes: nil] mutableCopy] autorelease];
    [[workString mutableString] appendString: @" "];
    return workString;
}
@end
