/* MLHTTPConnection.h created by mlaster on Fri 16-Jul-1999 */

#import <Foundation/Foundation.h>
#import "MLHTTPRequest.h"

// This makes gratuitous use of classDump...all because NSURL doesn't know how to
// go through a proxy server.

@protocol NSHTTPConnectionClient <NSObject>
- (void)requestWasCancelled:fp16;
- (void)connectionFailedDuringRequest:fp16;
- (void)receivedDataBlock:fp12 forRequest:fp16 finished:(BOOL)fp27;
- (void)receivedHeaders:fp12 forRequest:fp20;
@end

@class NSHTTPSocket;

@interface NSHTTPConnection:NSObject <NSHTTPConnectionClient>
{
    NSPort *_port;
    NSHost *_host;
    unsigned int _remotePort;
    NSLock *_lock;
    NSMutableArray *_newJobs;
    void *_completedJobs;
    int _currentSynchCondition;
    NSMutableArray *_synchCompletedJobs;
    NSConditionLock *_synchLock;
    NSHTTPSocket *_socket;
}
+ (void)initialize;
+ cachedConnectionForHost:fp12 port:(unsigned int)fp16;
+ connectionForHost:fp12 port:(unsigned int)fp16;
- (int)_nextSynchCondition;
- (NSHTTPConnection *) initWithHost:(NSHost *)aHost port:(unsigned int)aPort;
- host;
- (unsigned int)remotePortNumber;
- (NSData *) sendRequestSynchronously:(NSHTTPRequest *)aRequest headers:(id *)headers;
- (void)enqueueRequest:(NSHTTPRequest *)aRequest forClient:(id) aClient;
- (void)cancelRequest:fp12;
- (void)cancelFetchOfURL:fp12;
- (void)receivedHeaders:fp12 forRequest:fp16;
- (void)receivedDataBlock:(NSData *)receivedData forRequest:(NSHTTPRequest *)aRequest finished:(BOOL)flag;
- (void)connectionFailedDuringRequest:fp12;
- (void)requestWasCancelled:fp12;
- (void)handlePortMessage:(NSPortMessage *)aPortMessage;
- (void)portBecameInvalid:fp12;

@end

@interface MLHTTPConnection : NSHTTPConnection
{
}
+ (void) setupPosing;
- (NSHTTPConnection *) initWithHost:(NSHost *)aHost port:(unsigned int)aPort;

@end
