/* NSUserDefaults+ColorExtensions.m created by bbum on Fri 20-Aug-1999 */

#import "NSUserDefaults+ColorExtensions.h"

@implementation NSUserDefaults (ColorExtensions)
- (NSColor *) colorForKey: (NSString *) aDefaultName;
{
    NSData *colorData;

    NSString *possibleColor = [self stringForKey: aDefaultName];
    if (possibleColor != nil) {
        return [NSColor performSelector: NSSelectorFromString(possibleColor)];
    } else {
        colorData = [self dataForKey: aDefaultName];

        return [NSUnarchiver unarchiveObjectWithData: colorData];
    }
}

- (void) setColor: (NSColor *) aColor forKey: (NSString *) aKey;
{
    [self setObject: [NSArchiver archivedDataWithRootObject: aColor] forKey: aKey];
}
@end
