/* PreferencesController.m created by mlaster on Sat 17-Jul-1999 */

#import "PreferencesController.h"

@implementation PreferencesController

- (void) dealloc
{
    [symbolList release];
    [super dealloc];
}

- (void) awakeFromNib
{
    [self syncWithDefaults];
}

- (void) showPanel
{
    [prefPanel center];
    [prefPanel makeKeyAndOrderFront:self];
}

- (void) syncWithDefaults
{
    NSUserDefaults *defaults = nil;
    NSDictionary *workDictionary = nil;

    defaults = [NSUserDefaults standardUserDefaults];
    
    // sync symbol list
    workDictionary = [defaults dictionaryForKey:@"Symbols"];
    if (workDictionary == nil)
    {
        [symbolList release];
        symbolList = [[NSMutableDictionary alloc] init];
    }
    else
    {
        symbolList = [workDictionary mutableCopy];
    }
    
    shouldUseProxy = [defaults boolForKey:@"ShouldUseProxy"];
    [proxyCheckbox setState:shouldUseProxy];
    [proxyForm setEnabled:shouldUseProxy];
    [proxyCheckbox setNeedsDisplay:YES];
    [proxyForm setNeedsDisplay:YES];
    
    // sync proxy url
    [proxyServer release];
    proxyServer = [[defaults stringForKey:@"ProxyURL"] retain];
    if (proxyServer == nil)
    {
        proxyServer = @"";
    }
    [[proxyForm cellAtIndex:0] setStringValue:proxyServer];
    [proxyForm setNeedsDisplay:YES];
    [prefPanel setDocumentEdited:NO];

}

- (IBAction) addStock:(id)sender
{
    NSMutableDictionary *workDictionary = nil;
    NSString *symbol = nil;

    symbol = [[stockEntryField stringValue] uppercaseString];
    if ([symbolList objectForKey:symbol] == nil &&
        [symbol isEqualToString:@""] == NO)
    {
        workDictionary = [[NSMutableDictionary alloc] init];
        [workDictionary setObject:symbol forKey:@"Symbol"];
        [symbolList setObject:workDictionary forKey:symbol];
        [prefPanel setDocumentEdited:YES];
        [stockEntryField setStringValue:@""];
        [stockBrowser reloadColumn:0];
    }
}

- (IBAction) removeStocks:(id)sender
{
    NSArray *selection = nil;
    int i=0;
    selection = [stockBrowser selectedCells];
    if (selection != nil)
    {
        for (i=0;i<[selection count];i++)
        {
            [symbolList  removeObjectForKey:[[selection objectAtIndex:i] stringValue]];
        }
        [prefPanel setDocumentEdited:YES];
        [stockBrowser reloadColumn:0];
    }
}

- (IBAction) apply:(id)sender
{
    NSUserDefaults *defaults = nil;
    
    defaults = [NSUserDefaults standardUserDefaults];
    [defaults setObject:symbolList forKey:@"Symbols"];
    [defaults setBool:shouldUseProxy forKey:@"ShouldUseProxy"];
    [defaults setObject:proxyServer forKey:@"ProxyURL"];   
    [prefPanel setDocumentEdited:NO];
    if ([defaults synchronize] == NO)
    {
        NSLog(@"WARNING: Unable to synchronize defaults");
    }
    [[NSNotificationCenter defaultCenter] postNotificationName:SymbolListUpdatedNotification
                                                        object:self
                                                      userInfo:nil];
}

- (IBAction) toggleProxy:(NSButton *)sender
{
    shouldUseProxy = ([sender state] == 0) ? NO : YES;
    [proxyForm setEnabled:shouldUseProxy];
    [prefPanel setDocumentEdited:YES];
}

- (IBAction) proxyChanged:(NSTextField *)sender
{
    [proxyServer release];
    proxyServer = [[sender stringValue] retain];
}

// window delegate methods
- (BOOL) windowShouldClose:(id)sender
{
    BOOL retValue = NO;
    
    if ([prefPanel isDocumentEdited] == YES)
    {
        retValue = NSRunAlertPanel(@"Stock Tracker", @"Cancel preference changes?", @"No", @"Yes", nil);
    }
    return !retValue;
}

- (void)windowWillClose:(NSNotification *)aNotification
{
    [self syncWithDefaults];
}

// browser delegate methods
- (int)browser:(NSBrowser *)sender numberOfRowsInColumn:(int)column
{
    return [symbolList count];
}

- (void)browser:(NSBrowser *)sender willDisplayCell:(id)cell atRow:(int)row column:(int)column
{
    NSArray *sortedArray = nil;
    
    [cell setLeaf:YES];
//    [cell setStringValue:[symbolList objectAtIndex:row]];
    sortedArray = [[symbolList allKeys] sortedArrayUsingSelector:@selector(compare:)];
    [cell setStringValue:[sortedArray objectAtIndex:row]];
}
@end
