/* PropertyListCategories.m created by mlaster on Sat 17-Jul-1999 */

#import "PropertyListCategories.h"

@implementation NSObject (PropertyListSupport)
// we can't use the name propertyList because the NSString defines this method
// and it would lead to confusion
- (id) plist
/*"
Return an instance of a property list compatible class which is equivilent
to the reciever, or nil if this is not possible.
"*/
{
    id returnValue = nil;

    if ([self isKindOfClass:[NSData class]] || [self isKindOfClass:[NSString class]])
    {
        returnValue = self;
    }
    else if ([self isKindOfClass:[NSNumber class]])
    {
        returnValue = [(NSNumber *)self stringValue];
    }
    else
    {
        returnValue = nil;
    }
    
    return returnValue;
}
@end

@implementation NSArray (PropertyListSupport)

- (NSArray *) plist
{
    NSMutableArray *safeArray = nil;
    NSArray *returnArray = nil;
    int i=0;
    id object=nil;
    BOOL success = YES;

    safeArray = [[NSMutableArray alloc] init];
    for (i=0;i<[self count];i++)
    {
        object = [self objectAtIndex:i];
        object = [object plist];
        if (object == nil)
        {
            success = NO;
            break;
        }
        [safeArray addObject:object];
    }
    if (success == NO)
    {
        [safeArray release];
        returnArray = nil;
    }
    else
    {
        returnArray = [safeArray copy];
        [safeArray release];
        [returnArray autorelease];
    }
    return returnArray;
}

@end

@implementation NSDictionary (PropertyListSupport)

- (NSDictionary *) plist
{
    NSArray *keys = nil;
    NSMutableDictionary *safeDictionary = nil;
    NSDictionary *returnDictionary = nil;
    id key = nil;
    id object = nil;
    int i=0;
    BOOL success = YES;

    safeDictionary = [[NSMutableDictionary alloc] init];
    keys = [self allKeys];
    for (i=0;i<[keys count];i++)
    {
        // make sure the key is plist-safe
        key = [keys objectAtIndex:i];
        if ([[key class] isKindOfClass:[NSString class]])
        {
            NSLog(@"ERROR: Only NSString keys currently supported!");
            success = NO;
            break;
        }
        // convert objects into plist-safe classes
        object = [self objectForKey:key];
        object = [[[object plist] copy] autorelease];
        if (object == nil)
        {
            NSLog(@"ERROR: Unable to convert [%@] into a plist-safe representation!",
                  [self objectForKey:key]);
            success = NO;
            break;
        }

        [safeDictionary setObject:object forKey:key];
    }
    if (success == NO)
    {
        [safeDictionary release];
        safeDictionary = nil;
    }
    else
    {
        returnDictionary = [safeDictionary copy];
        [safeDictionary release];
        [returnDictionary autorelease];
    }
    return returnDictionary;
}

@end
