#import "WindowController.h"
#import "MLMarqueeView.h"
#import "StockDataSource.h"

@implementation WindowController

- init
{
    [super init];

    symbolUpdateInterval = [[NSUserDefaults standardUserDefaults] floatForKey: @"SymbolUpdateInterval"];
    
    return self;
}

- (void) reloadSymbols
{
    [dataSource reloadSymbols];
}

- (StockDataSource *) dataSource
{
    return dataSource;
}

- (void) _dataUpdated:(NSNotification *)aNotification
{
    [marqueeView setAttributedString:[dataSource attributedString]];
}
- (void) _updateStockData
{
    [dataSource update];
}

- (void) _updateTick:(NSTimer *)aTimer
{
    [self _updateStockData];
    [NSTimer scheduledTimerWithTimeInterval:[aTimer timeInterval]
                                     target:self
                                   selector:_cmd
                                   userInfo:[aTimer userInfo]
                                    repeats:NO];
}

// prevent vertical resizing
- (NSSize)windowWillResize:(NSWindow *)sender toSize:(NSSize)proposedFrameSize
{
    return NSMakeSize(proposedFrameSize.width,[sender frame].size.height);
}

- (void) dealloc
{
    [dataSource release];
    [super dealloc];
}

- (void) awakeFromNib
{
    NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
    BOOL displayInMenuBar = [userDefaults boolForKey: @"DisplayInMenuBar"];
    
    if ([window setFrameAutosaveName:@"TickerWindow"] == NO) {
        [NSException raise:NSGenericException format:@"'TickerWindow' frame name already in use!"];
    }
    dataSource = [[StockDataSource dataSource] retain];
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(_dataUpdated:)
                                                 name:StockDataUpdatedNotification
                                               object:nil];

    if (displayInMenuBar == NO) {
        [window orderFront: self];
        [window setLevel:NSFloatingWindowLevel];
    }
    [NSTimer scheduledTimerWithTimeInterval: symbolUpdateInterval
                                     target:self
                                   selector:@selector(_updateTick:)
                                   userInfo:nil
                                    repeats:NO];

}

+ (NSFont *) baseFont;
{
    NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
    BOOL displayInMenuBar = [userDefaults boolForKey: @"DisplayInMenuBar"];
    int fontSize;
    BOOL useFixedPitchFont;
    NSFont *baseFont;

    if (displayInMenuBar == YES) {
        fontSize = [userDefaults floatForKey: @"TickerMenuFontSize"];
        useFixedPitchFont = [userDefaults boolForKey: @"TickerMenuUsesFixedPitchFont"];
    } else {
        fontSize = [userDefaults floatForKey: @"TickerFontSize"];
        useFixedPitchFont = [userDefaults boolForKey: @"TickerUsesFixedPitchFont"];
    }

    if (useFixedPitchFont == YES)
        baseFont = [NSFont userFixedPitchFontOfSize: fontSize];
    else
        baseFont = [NSFont userFontOfSize: fontSize];

    return baseFont;
}

- (NSWindow *) window;
{
    return window;
}

- (MLMarqueeView *) marqueeView;
{
    return marqueeView;
}

- (void) killWindow;
{
    // assumes caller has grabbed whatever objects are needed by this object
    [window setDelegate: nil];
    [window setContentView: nil];
    [window release];
    window = nil;
}
@end
