/*
    File:       Browser.m

    Contains:   Source code for the browser.

    Written by: Laura Rawson

    Created:    7/10/97

    Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

    Change History (most recent first):
	Version 1.0d7 : HI changes - DG
        Version 1.0d5:  Fixed a potential bug in the set methods of Teacher and Classroom by
                        changing the way the releasing and retaining of objects were being handled. 
        Version 1.0d4:  Recompiled for Rhapsody on PPC.  Added missing dealloc methods.
                        Renamed instance variables to use a more paralell naming convention.
                        Added command key equivalents to Quit and Hide menu items. Changed the
                        implementation of setTeachers and setStudents to work in a cleaner manner.
        Version 1.0d3 : Changed name of nib file to SampleBrowser.nib
        Version 1.0d2 : Added generateTestData to demonstrate a more realistic
                        example of loading a browser. Also fixed a few minor user
                        interface problems.
        Version 1.0d1 : Initial version


    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/


#import "Browser.h"
#import "Classroom.h"
#import "Teacher.h"


@implementation Browser
 
- (id)init
{
    self = [super init];
    [self generateTestData];

    return self;
}

-(void)dealloc
{
    [studentArray release];
    [teacherArray release];
    [classArray release];
    [super dealloc];
}

- (void)generateTestData
{
    /* This method generates test data to be used by the Browser to demonstate
       loading data into a browser. The test data represents a class roster for
       the seventh and eigth grade classrooms at a school. The Classroom object represents
       roster information about a particular grade level. In this case two Classroom
       instances are created: one for the seventh grade and one for the eigth. Each
       Classroom contains an array of Teacher objects representing each teacher that
       teaches at the grade-level represented. Each Teacher object contains an array of
       student names representing the students in the teacher's class. Thus, the end result
       is a set of nested arrays.
    */
    
    int startPos, length;

    studentArray = [NSMutableArray array];
    teacherArray = [NSMutableArray array];
    classArray = [NSMutableArray array];

    // First, create an array of student names.
    [studentArray addObject:[NSString stringWithFormat:@"Joe Smith"]];
    [studentArray addObject:[NSString stringWithFormat:@"Sally Web"]];
    [studentArray addObject:[NSString stringWithFormat:@"Don Dillon"]];
    [studentArray addObject:[NSString stringWithFormat:@"Kate Jay"]];
    [studentArray addObject:[NSString stringWithFormat:@"Mary Key"]];
    [studentArray addObject:[NSString stringWithFormat:@"Jill Help"]];
    [studentArray addObject:[NSString stringWithFormat:@"Matt Wild"]];
    [studentArray addObject:[NSString stringWithFormat:@"Kevin Deen"]];
    [studentArray addObject:[NSString stringWithFormat:@"June Bug"]];
    [studentArray addObject:[NSString stringWithFormat:@"Kathy Miles"]];
    [studentArray addObject:[NSString stringWithFormat:@"Mike Conner"]];
    [studentArray addObject:[NSString stringWithFormat:@"Paul Russel"]];
    [studentArray addObject:[NSString stringWithFormat:@"Patty May"]];
    [studentArray addObject:[NSString stringWithFormat:@"Mildred Green"]];
    [studentArray addObject:[NSString stringWithFormat:@"Gerry Wilson"]];

    // Now create a teacher object for each teacher and assign a list of
    // students.
    teacher = [[Teacher alloc] init];
    [teacher setTeacherName:[NSString stringWithFormat:@"Miss Mathman"]];
    startPos = 0;
    length = 4;     // The first 4 students in studentArray will be assigned.
    [teacher setStudents:[studentArray subarrayWithRange: NSMakeRange(startPos,length)]];
    [teacherArray addObject:teacher];
    [teacher release];

    teacher = [[Teacher alloc] init];
    [teacher setTeacherName:[NSString stringWithFormat:@"Mr Speach"]];
    startPos = 4;
    length = 5;    // The next 5 students in studentArray will be assigned.
    [teacher setStudents:[studentArray subarrayWithRange: NSMakeRange(startPos,length)]];
    [teacherArray addObject:teacher];
    [teacher release];

     teacher = [[Teacher alloc] init];
     [teacher setTeacherName:[NSString stringWithFormat:@"Mr West"]];
     startPos = 9;
     length = 6;  // The last 6 students in studentArray will be assigned.
     [teacher setStudents:[studentArray subarrayWithRange: NSMakeRange(startPos,length)]];
     [teacherArray addObject:teacher];
     [teacher release];

   // Now create a classroom object for each grade-level and assign a list of
   // teachers.
    classroom = [[Classroom alloc] init];
    [classroom setGrade: @"Seventh Grade"];
    startPos = 0;
    length = 2;   // Assign the first 2 teachers in teacherArray to seventh grade.
    [classroom setTeachers:[teacherArray subarrayWithRange: NSMakeRange(startPos, length)]];
    [classArray addObject:classroom];
    [classroom release];

    classroom = [[Classroom alloc] init];
    [classroom setGrade: @"Eigth Grade"];
    startPos = 2;
    length = 1;   // Assign the last teacher in teacherArray to eigth grade
    [classroom setTeachers:[teacherArray subarrayWithRange: NSMakeRange(startPos, length)]];
    [classArray addObject:classroom];
    [classroom release];

    [studentArray retain];
    [teacherArray retain];
    [classArray retain];

} 

- (void)awakeFromNib
{
    // Load the first column
    [browser loadColumnZero];

    // Now set up the browser the way I want it.
    [browser setMinColumnWidth:100];
    [browser setMaxVisibleColumns:NUMCOLUMNS];
    [browser setSeparatesColumns:YES];
    [[browser window] makeKeyAndOrderFront: nil];
}

   
-(int)browser:(NSBrowser *)sender numberOfRowsInColumn:(int)column
{
    /* This method returns the number of rows to be displayed in the selected column.
       The selected row in the previous column will be used as the index into
       the appropriate array.  */
    
    short grade, teacherNm;
    int numRows = 0;
    Classroom *classObj;
    Teacher *thisTeacher;
    
    switch(column)
      {
        case 0:  numRows = [classArray count]; break; // There is one entry per grade-level in classArray
            
        case 1:  grade = [sender selectedRowInColumn:0];     // Count number of teachers for selected
                 classObj = [classArray objectAtIndex:grade];// grade.
                 numRows = [[classObj teachers] count];
                 break;

        case 2:  grade = [sender selectedRowInColumn:0];     // Count number of students for selected
                 teacherNm = [sender selectedRowInColumn:1]; // teacher.
                 classObj = [classArray objectAtIndex:grade];
                 thisTeacher = [[classObj teachers]objectAtIndex:teacherNm];
                 numRows = [[thisTeacher students] count];
                 break;
      }
   
    return numRows;
}

-(void)browser:(NSBrowser *)sender willDisplayCell:(id)cell atRow:(int)row column:(int)column

/* This method determines what should be displayed in the current browser. The selected row in the
   previous column will be used as the index into the appropriate array.
*/

{
    short grade, teacherNm;
    Classroom *classObj;
    Teacher *thisTeacher;
    
    switch(column)
      {
       // Get the name of the grade indicated by the current row.
        case 0:  classObj = [classArray objectAtIndex:row];
                 [cell setStringValue:[classObj grade]];  
                 break;

       // Get the name of the teacher indicated by the current row and dependant on the 
       // selected grade.
        case 1:  grade = [sender selectedRowInColumn:0];    
                 classObj = [classArray objectAtIndex:grade]; 
                 [cell setStringValue:[[[classObj teachers]objectAtIndex:row] teacherName]];
                 break;

      // Get the name of the student indicated by the current row and dependant on the
      // selected grade and teacher.
        case 2:  grade = [sender selectedRowInColumn:0];
                 teacherNm = [sender selectedRowInColumn:1];
                 classObj = [classArray objectAtIndex:grade];
                 thisTeacher = [[classObj teachers] objectAtIndex:teacherNm];
                 [cell setStringValue:[[thisTeacher students] objectAtIndex:row]];
                 break;
      }

        // Set number of columns to display
        [cell setLeaf:(column == NUMCOLUMNS-1)];

        // data is ready to display:
        [cell setLoaded:YES];
        
}

@end
