/*
    File:       Controller.h

    Contains:   Central control object for sample.

    Written by: Quinn "The Eskimo!"

    Created:    Tue 10-Jun-1997

    Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

    Change History (most recent first):

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

#import <AppKit/AppKit.h>

// IMPORTANT: See the documentation ("ReadMe.rtf" under Supporting Files) for
// big picture information about this project.

@class TransferServer;

@interface Controller : NSObject
{
    // Interface Builder connections.
    
    id mainWindow;
    id textField;

    // Set up in our init method.
    
    NSConnection *connectionToTransferServer;
        // The connection to transferServer.
    
    TransferServer *transferServer;
        // The transfer server itself, well actually a proxy for it.
        // You can tell the server to perform commands simply by
        // invoking methods on this object.
}

- (id)init;
    // Creates an NSConnection and starts a thread in which to run
    // the server.  The server thread creates a remote server object
    // and then calls back our setServer method to let us know about it.

- (void)setServer:(id)serverObject;
    // The server calls this routine to let us know about the remote
    // object it has created for us.  We store this object in our
    // instance variables so that we can send messages to the remote
    // server via a simple method call.  [Actually serverObject is
    // not the real object, but a proxy that Distributed Objects has
    // created for us when the server invoked our setServer method.
    // But the rest of this program doesn't care about that.]

- (oneway void)outputString:(NSString *)theString;
    // Appends theString to the output text field.  This routine is
    // callable both by the controller object running in the main
    // thread, and by the server object running in a secondary thread.
    // The "oneway" type qualifier informs the Distributed Object
    // system that it does not have to wait for this message to be
    // delivered before letting the sender continue running.  This
    // is a sensible thing to do for things like updating progress
    // information, because you don't want your threaded operation
    // to stop and wait to synchronise with the main thread just so
    // that you can confirm that the progress bar has been updated
    // correctly.

// Interface Builder Actions

- (void)doSomethingSlow:(id)sender;
    // Called when the "Something Slow" button is clicked.
    // It requests the transferServer object to do something
    // slow.

- (void)doSomethingSlower:(id)sender;
    // Called when the "Something Slower" button is clicked.
    // It requests the transferServer object to do something
    // even slower than something slow.

@end
