/* NSView+OWPrinting.m created by aspinall on Tue 12-May-1998 */

#import "NSView+OWPrinting.h"
#import "PrintPreferences.h"

#import <OmniFoundation/OFUserDefaults.h>
#import <OWF/OWURL.h>


@implementation NSView (OWPrinting)

- (NSString *)stringForPosition:(NSString *)pos
{
    NSMutableString *text = [NSMutableString string];
    OFUserDefaults *ud = [OFUserDefaults sharedUserDefaults];

    if ( [ud boolForKey:PEShowURL] == YES)
    {
        if ( [[ud stringForKey:PEPositionURL] isEqualToString:pos] == YES)
        {
            OWURL	*url = [[[[[self superview] superview] superview] address] url];
            NSString *urlString = [url compositeString];

            // especially long URLs can be trimmed.
            if ( [urlString length] > 75 )
            {
                NSMutableString	*tempUrl = [NSMutableString string];
                NSArray			*comp = [OWURL pathComponentsForPath:[url compositeString]];
                NSEnumerator	*compEnum = [comp objectEnumerator];
                NSString		*aComp = nil;

                while ( aComp = [compEnum nextObject] )
                {
                    if ( [aComp length] > 25 )
                        [tempUrl appendString:@".../"];
                    else
                        [tempUrl appendFormat:@"%@/", aComp];
                }
                urlString = tempUrl;
            }

            [text appendString:urlString];
        }
    }

    if ( [ud boolForKey:PEShowPageNumber] == YES)
    {
        if ( [[ud stringForKey:PEPositionPageNumber] isEqualToString:pos] == YES)
        {
            [text appendFormat:[ud stringForKey:PEPageNumberFormat], [[NSPrintOperation currentOperation] currentPage]];
        }
    }

    if ( [ud boolForKey:PEShowDate] == YES)
    {
        if ( [[ud stringForKey:PEPositionDate] isEqualToString:pos] == YES)
        {
            [text appendString:[[NSCalendarDate calendarDate] descriptionWithCalendarFormat:[ud stringForKey:PEDateFormat]]];
        }
    }

    if ( [ud boolForKey:PEShowText] == YES)
    {
        if ( [[ud stringForKey:PEPositionText] isEqualToString:pos] == YES)
        {
            [text appendString:[ud stringForKey:PEText]];
        }
    }

    return text;
}

- (void)drawPageBorderWithSize:(NSSize)borderSize
{
    NSString	*string = nil;
    NSDPSContext *context = [NSDPSContext currentContext];
    
    /* Draw a header and footer lines. */
    /* don't you love magic numbers?  I suppose the user could pick their own indentation value, but we could also let the user pick a font and size .. Anyway, 30 pixels (printed) seem about right, so the line needs to drop a couple of extra pixels to accomodate the text, and the bottom has to lift a little extra for the same reason. */

    if ( [[OFUserDefaults sharedUserDefaults] boolForKey:PEShowHeaderLine] == YES)
    {
        [context printFormat:@"1 setlinewidth 30 %g moveto %g %g lineto stroke\n", borderSize.height - 33.0, borderSize.width - 30.0, borderSize.height - 33.0];
    }

    if ( [[OFUserDefaults sharedUserDefaults] boolForKey:PEShowFooterLine] == YES)
    {
        [context printFormat:@"1 setlinewidth 30 40 moveto %g 40 lineto stroke\n", borderSize.width - 30.0];
    }

    [context printFormat:@"/Helvetica findfont\n"];
    [context printFormat:@"10 scalefont\n"];
    [context printFormat:@"setfont\n"];

    // top left
    string = [self stringForPosition:TopLeft];
    if ( string && ([string length] > 0));
    {
        NSString *owDPSfunction = [NSString stringWithFormat:@"OW%@", TopLeft];
        [context printFormat:@"/%@ (%@) def\n", owDPSfunction, string];
        [context printFormat:@"%g %g moveto\n", 30.0, borderSize.height - 30.0];
        [context printFormat:@"%@ show\n", owDPSfunction];
    }

    // top middle
    string = [self stringForPosition:TopMiddle];
    if ( string && ([string length] > 0));
    {
        NSString *owDPSfunction = [NSString stringWithFormat:@"OW%@", TopMiddle];
        [context printFormat:@"/%@ (%@) def\n", owDPSfunction, string];
        [context printFormat:@"%g %@ stringwidth pop 2.0 div sub\n", (borderSize.width/2.0), owDPSfunction];
        [context printFormat:@"%g moveto\n", borderSize.height - 30.0];
        [context printFormat:@"%@ show\n", owDPSfunction];
    }

    // top right
    string = [self stringForPosition:TopRight];
    if ( string && ([string length] > 0));
    {
        NSString *owDPSfunction = [NSString stringWithFormat:@"OW%@", TopLeft];
        [context printFormat:@"/%@ (%@) def\n", owDPSfunction, string];
        [context printFormat:@"%g %@ stringwidth pop sub\n", (borderSize.width - 30.0), owDPSfunction];
        [context printFormat:@"%g moveto\n", borderSize.height - 30.0];
        [context printFormat:@"%@ show\n", owDPSfunction];
    }

    // bottom left
    string = [self stringForPosition:BottomLeft];
    if ( string && ([string length] > 0));
    {
        NSString *owDPSfunction = [NSString stringWithFormat:@"OW%@", BottomLeft];
        [context printFormat:@"/%@ (%@) def\n", owDPSfunction, string];
        [context printFormat:@"%g %g moveto\n", 30.0, 30.0];
        [context printFormat:@"%@ show\n", owDPSfunction];
    }

    // bottom middle
    string = [self stringForPosition:BottomMiddle];
    if ( string && ([string length] > 0));
    {
        NSString *owDPSfunction = [NSString stringWithFormat:@"OW%@", BottomMiddle];
        [context printFormat:@"/%@ (%@) def\n", owDPSfunction, string];
        [context printFormat:@"%g %@ stringwidth pop 2.0 div sub\n", (borderSize.width/2.0), owDPSfunction];
        [context printFormat:@"%g moveto\n", 30.0];
        [context printFormat:@"%@ show\n", owDPSfunction];
    }

    // bottom right
    string = [self stringForPosition:BottomRight];
    if ( string && ([string length] > 0));
    {
        NSString *owDPSfunction = [NSString stringWithFormat:@"OW%@", BottomLeft];
        [context printFormat:@"/%@ (%@) def\n", owDPSfunction, string];
        [context printFormat:@"%g %@ stringwidth pop sub\n", (borderSize.width - 30.0), owDPSfunction];
        [context printFormat:@"%g moveto\n", 30.0];
        [context printFormat:@"%@ show\n", owDPSfunction];
    }
}

@end
