#import "PrintPreferences.h"

#import <OmniFoundation/OFUserDefaults.h>

NSString *PEShowHeaderLine		= @"PEShowHeaderLine";
NSString *PEShowFooterLine		= @"PEShowFooterLine";

NSString *PEShowURL				= @"PEShowURL";
NSString *PEShowPageNumber		= @"PEShowPageNumber";
NSString *PEShowDate			= @"PEShowDate";
NSString *PEShowText			= @"PEShowText";

NSString *PEPositionURL			= @"PEPositionURL";
NSString *PEPositionDate		= @"PEPositionDate";
NSString *PEPositionPageNumber	= @"PEPositionPageNumber";
NSString *PEPositionText		= @"PEPositionText";

NSString *PEPageNumberFormat	= @"PEPageNumberFormat";
NSString *PEDateFormat			= @"PEDateFormat";
NSString *PEText				= @"PEText";

NSString *TopRight				= @"TopRight";
NSString *TopMiddle				= @"TopMiddle";
NSString *TopLeft				= @"TopLeft";
NSString *BottomRight			= @"BottomRight";
NSString *BottomMiddle			= @"BottomMiddle";
NSString *BottomLeft			= @"BottomLeft";

@implementation PrintPreferences

- (int)tagForPosition:(NSString *)position
{
    if ( position )
    {
        if ( [position isEqualToString:TopLeft] == YES )
            return 0;
        else if ( [position isEqualToString:TopMiddle] == YES )
            return 1;
        else if ( [position isEqualToString:TopRight] == YES )
            return 2;
        else if ( [position isEqualToString:BottomLeft] == YES )
            return 6;
        else if ( [position isEqualToString:BottomMiddle] == YES )
            return 7;
    }
    return 8;
}

- (NSString *)positionForTag:(int)tag
{
    switch (tag)
    {
        case 0: return TopLeft; break;
        case 1: return TopMiddle; break;
        case 2: return TopRight; break;
        case 6: return BottomLeft; break;
        case 7: return BottomMiddle; break;
        case 8:
        default: return BottomRight; break;
    }
    return BottomRight;
}

// This method updates the UI to reflect the current defaults
- (void)updateUI
{
    OFUserDefaults *ud = [OFUserDefaults sharedUserDefaults];

    [headerLineIncluded setState:[ud boolForKey:PEShowHeaderLine]];
    [footerLineIncluded setState:[ud boolForKey:PEShowFooterLine]];

    [additionalIncluded setState:[ud boolForKey:PEShowText]];
    [additionalPosition selectCellWithTag:[self tagForPosition:[ud stringForKey:PEPositionText]]];
    [additionalText setStringValue:[ud stringForKey:PEText]];

    [dateFormat setStringValue:[ud stringForKey:PEDateFormat]];
    [dateIncluded setState:[ud boolForKey:PEShowDate]];
    [datePosition selectCellWithTag:[self tagForPosition:[ud stringForKey:PEPositionDate]]];

    [pageNoFormat setStringValue:[ud stringForKey:PEPageNumberFormat]];
    [pageNoIncluded setState:[ud boolForKey:PEShowPageNumber]];
    [pageNoPosition selectCellWithTag:[self tagForPosition:[ud stringForKey:PEPositionPageNumber]]];

    [urlIncluded setState:[ud boolForKey:PEShowURL]];
    [urlPosition selectCellWithTag:[self tagForPosition:[ud stringForKey:PEPositionURL]]];

    [sampleDate setStringValue:[[NSCalendarDate calendarDate] descriptionWithCalendarFormat:[ud stringForKey:PEDateFormat]]];
    [samplePageNumber setStringValue:[NSString stringWithFormat:[ud stringForKey:PEPageNumberFormat], 1]];
}

- (void)setValueForSender:(id)sender
{
    OFUserDefaults *ud = [OFUserDefaults sharedUserDefaults];

    // additional Text
    if ( sender == headerLineIncluded )
        [ud setBool:[sender state] forKey:PEShowHeaderLine];

    if ( sender == footerLineIncluded )
        [ud setBool:[sender state] forKey:PEShowFooterLine];

    if ( sender == additionalIncluded )
        [ud setBool:[sender state] forKey:PEShowText];

    if ( sender == additionalPosition )
        [ud setObject:[self positionForTag:[[sender selectedCell] tag]] forKey:PEPositionText];

    if ( sender == additionalText )
        [ud setObject:[sender stringValue] forKey:PEText];

    // date 
    if ( sender == dateFormat )
    {
        [ud setObject:[sender stringValue] forKey:PEDateFormat];
        [sampleDate setStringValue:[[NSCalendarDate calendarDate] descriptionWithCalendarFormat:[sender stringValue]]];
    }

    if ( sender == dateIncluded )
        [ud setBool:[sender state] forKey:PEShowDate];

    if ( sender == datePosition )
        [ud setObject:[self positionForTag:[[sender selectedCell] tag]] forKey:PEPositionDate];

    // page number
    if ( sender == pageNoFormat )
    {
        [ud setObject:[sender stringValue] forKey:PEPageNumberFormat];
        [samplePageNumber setStringValue:[NSString stringWithFormat:[sender stringValue], 1]];
    }

    if ( sender == pageNoIncluded )
        [ud setBool:[sender state] forKey:PEShowPageNumber];

    if ( sender == pageNoPosition )
        [ud setObject:[self positionForTag:[[sender selectedCell] tag]] forKey:PEPositionPageNumber];

    // url
    if ( sender == urlIncluded )
        [ud setBool:[sender state] forKey:PEShowURL];

    if ( sender == urlPosition )
        [ud setObject:[self positionForTag:[[sender selectedCell] tag]] forKey:PEPositionURL];
}

@end
