// MORegexFormatterInspector.m
// MOKit - Yellow Box
// MOFormatterPalette
//
// Copyright 1996-1999, Mike Ferris.
// All rights reserved.

// ABOUT MOKit
//
// MOKit is a collection of useful and general objects.  Permission is
// granted by the author to use MOKit in your own programs in any way
// you see fit.  All other rights to the kit are reserved by the author
// including the right to sell these objects as part of a LIBRARY or as
// SOURCE CODE.  In plain English, I wish to retain rights to these
// objects as objects, but allow the use of the objects as pieces in a
// fully functional program.  NO WARRANTY is expressed or implied.  The author
// will under no circumstances be held responsible for ANY consequences to
// you from the use of these objects.  Since you don't have to pay for
// them, and full source is provided, I think this is perfectly fair.

#import "MORegexFormatterInspector.h"
#import <MOKit/MOKit.h>

@implementation MORegexFormatterInspector

/************************ Left over test methods ************************/

#if 0
- (void)ok:(id)sender {
    NSLog(@"%@: object is %@", MOFullMethodName(self, _cmd), [self object]);
    [super ok:sender];
}

- (void)touch:(id)sender {
    NSLog(@"%@: object is %@", MOFullMethodName(self, _cmd), [self object]);
    [super touch:sender];
}

- (void)textDidBeginEditing:(NSNotification *)notification {
    NSLog(@"%@: object is %@", MOFullMethodName(self, _cmd), [self object]);
    [super textDidBeginEditing:notification];
}
#endif


- (void)dealloc {
    [[NSNotificationCenter defaultCenter] removeObserver:self];
    [super dealloc];
}

- (BOOL)wantsButtons {
    return NO;
}

- (void)updateButtons {
    BOOL hasSelection = (([expressionTableView numberOfSelectedRows] > 0) ? YES : NO);
    [[expressionButtons cellAtRow:0 column:1] setEnabled:hasSelection];
}

- (void)applicationWillUpdate:(NSNotification *)notification {
    if ([[self window] isVisible]) {
        [self updateButtons];
    }
}

- (void)revert:(id)sender {
    MORegexFormatter *formatter = [self object];
    [super revert:sender];
    [allowsEmptyStringCheckbox setState:[formatter allowsEmptyString]];
    [formatPatternTextField setStringValue:[formatter formatPattern]];
    [expressionTableView reloadData];
    [self updateButtons];
}

- (NSWindow *)window {
    id window = [super window];
    if (!window) {
        [NSBundle loadNibNamed:@"MORegexFormatterInspector" owner:self];
        window = [super window];

        // Set formatter for table view.
        [[[[expressionTableView tableColumns] objectAtIndex:0] dataCell] setFormatter:[[MORESyntaxFormatter allocWithZone:[expressionTableView zone]] init]];
        
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(applicationWillUpdate:) name:NSApplicationWillUpdateNotification object:NSApp];
    }
    return window;
}

- (void)newExpressionAction:(id)sender {
    MORegexFormatter *formatter = [self object];
    MORegularExpression *expression = [[MORegularExpression allocWithZone:[formatter zone]] initWithExpressionString:NSLocalizedStringFromTableInBundle(@"newExpression", @"FormatterPalette", [NSBundle bundleForClass:[self class]], @"Default expression for newly added expressions in MORegexFormatter inspector.")];
    if (expression) {
        [formatter addRegularExpression:expression];
    }
    [expressionTableView reloadData];
}

- (void)removeExpressionAction:(id)sender {
    MORegexFormatter *formatter = [self object];
    unsigned i;
    
    for (i = [expressionTableView numberOfRows]; i>0; --i) {
        if ([expressionTableView isRowSelected:i]) {
            [formatter removeRegularExpressionAtIndex:i];
        }
    }
    [expressionTableView reloadData];
}

- (void)allowsEmptyStringAction:(id)sender {
    BOOL flag = [allowsEmptyStringCheckbox state];
    [[self object] setAllowsEmptyString:flag];
}

- (int)numberOfRowsInTableView:(NSTableView *)tableView {
    return [[[self object] regularExpressions] count];
}

- (id)tableView:(NSTableView *)tableView objectValueForTableColumn:(NSTableColumn *)tableColumn row:(int)row {
    return [[[self object] regularExpressions] objectAtIndex:row];
}

- (void)tableView:(NSTableView *)tableView setObjectValue:(id)expression forTableColumn:(NSTableColumn *)tableColumn row:(int)row {
    if (expression) {
        [[self object] replaceRegularExpressionAtIndex:row withRegularExpression:expression];
    }
}

- (void)controlTextDidEndEditing:(NSNotification *)notification {
    id notifier = [notification object];
    if (notifier == formatPatternTextField) {
        [[self object] setFormatPattern:[notifier stringValue]];
    }
}

@end
