// MORESyntaxFormatter.m
// MOKit - Yellow Box
//
// Copyright 1996-1999, Mike Ferris.
// All rights reserved.

// ABOUT MOKit
//
// MOKit is a collection of useful and general objects.  Permission is
// granted by the author to use MOKit in your own programs in any way
// you see fit.  All other rights to the kit are reserved by the author
// including the right to sell these objects as part of a LIBRARY or as
// SOURCE CODE.  In plain English, I wish to retain rights to these
// objects as objects, but allow the use of the objects as pieces in a
// fully functional program.  NO WARRANTY is expressed or implied.  The author
// will under no circumstances be held responsible for ANY consequences to
// you from the use of these objects.  Since you don't have to pay for
// them, and full source is provided, I think this is perfectly fair.

#import <MOKit/MOKit.h>

@implementation MORESyntaxFormatter

- (NSString *)stringForObjectValue:(id)obj {
    return ((obj && [obj isKindOfClass:[MORegularExpression class]]) ? [obj expressionString] : @"");
}

- (BOOL)getObjectValue:(id *)obj forString:(NSString *)string errorDescription:(NSString **)error {
    if (string && ![string isEqualToString:@""]) {
        MORegularExpression *expression = [[MORegularExpression alloc] initWithExpressionString:string];
        if (expression) {
            if (obj) {
                *obj = expression;
            }
            return YES;
        } else {
            if (error) {
                *error = NSLocalizedStringFromTableInBundle(@"Regular expression string is not valid.", @"MOKit", [NSBundle bundleForClass:[self class]], @"Displayable error message for mal-formed regular expressions.");
            }
            return NO;
        }
    } else {
        // nil or empty string
        if (obj) {
            *obj = nil;
        }
        return YES;
    }
}

@end
