// MORegularExpression_Private.m
// MOKit - Yellow Box
//
// Copyright 1996-1999, Mike Ferris.
// All rights reserved.

// ABOUT MOKit
//
// MOKit is a collection of useful and general objects.  Permission is
// granted by the author to use MOKit in your own programs in any way
// you see fit.  All other rights to the kit are reserved by the author
// including the right to sell these objects as part of a LIBRARY or as
// SOURCE CODE.  In plain English, I wish to retain rights to these
// objects as objects, but allow the use of the objects as pieces in a
// fully functional program.  NO WARRANTY is expressed or implied.  The author
// will under no circumstances be held responsible for ANY consequences to
// you from the use of these objects.  Since you don't have to pay for
// them, and full source is provided, I think this is perfectly fair.

#import "MORegularExpression_Private.h"
#import "regexp_stuff.h"

_MOregexp *_MOTestAndCompileExpressionString(NSString *expressionString, NSZone *zone) {
    // Caller frees return value if non-null.
    _MOregexp *re = NULL;
    if (expressionString) {
        re = _MOregcomp((char *)[expressionString cString], zone);
    }
    return re;
}

BOOL _MOTestAndMatchCandidateWithExpression(NSString *candidate, _MOregexp *re, const char **candidateCString) {
    BOOL retVal = NO;
    if (candidate) {
        char *cStr = (char *)[candidate cString];
        retVal = (_MOregexec(re, cStr) ? YES : NO);
        if (candidateCString) {
            *candidateCString = cStr;
        }
    }
    return retVal;
}
