/* MF: This file has been modified to attempt to limit the namepsace impact of its external declarations. */

/*
 * Henry Spencer regular expressions are great but somewhat limited
 * (compared to Perl 5 regular expressions).
 *
 * That's why I've added trivial parsings like '\a', '\e', '\f', '\n', '\r' and '\t'
 * but also characters classes like '\d', '\D', '\w', '\W', '\s' and '\S'.
 *
 * Permission is granted to anyone to use this modified software for any
 * purpose on any computer system, and to redistribute it freely,
 * subject to the following restriction:
 *
 *   The author (VG) is not responsible for the consequences of use of
 *   this modified software, no matter how awful, even if they arise
 *   from defects in it.
 *
 * Modifications copyright (c) 1998 by InfoDesign Communications.
 * Written by Vivian Girel <vivian@infodesign.net>.
 *
 */

/*
 * Definitions etc. for regexp(3) routines.
 *
 * Caveat:  this is V8 regexp(3) [actually, a reimplementation thereof],
 * not the System V one.
 */

#ifndef _MO_REGEXP_H_
#define _MO_REGEXP_H_

#import <Foundation/NSZone.h>
#import <MOKit/MOKitDefines.h>

#define MO_REGEX_NSUBEXP  10

typedef struct _MOregexp {
	char *startp[MO_REGEX_NSUBEXP];
	char *endp[MO_REGEX_NSUBEXP];
        char regstart;		/* Internal use only. */
        char reganch;		/* Internal use only. */
        char *regmust;		/* Internal use only. */
        int regmlen;		/* Internal use only. */
        char program[1];	/* Unwarranted chumminess with compiler. */
} _MOregexp;

MOKIT_PRIVATE_EXTERN _MOregexp *_MOregcomp(char *exp, NSZone *resultZone);
MOKIT_PRIVATE_EXTERN int _MOregexec(register _MOregexp *prog, register char *string);
MOKIT_PRIVATE_EXTERN void _MOregsub(_MOregexp *prog, char *source, char *dest);

/*
 * The first byte of the regexp internal "program" is actually this magic
 * number; the start node begins in the second byte.
 */
#define	MO_REGEX_MAGIC_NUMBER	0234

#endif /* _MO_REGEXP_H_ */
