#import "TWInspector.h"
#import "ThumbWheel.h"

@implementation TWInspector : IBInspector

- init
{
    [super init];
    [NSBundle loadNibNamed:@"TWInspector" owner:self];
    return self;
}

- (void)ok:(id)sender
{
    [[self object] takeDisplayModeFromMatrix:displayModeMatrix];
    [[self object] takeDirectionFromMatrix:directionMatrix];
    [[self object] setFloatValue:[currentText floatValue]];

    [[self object] takeVisibleMinFrom:visibleMinText];
    [[self object] takeVisibleMaxFrom:visibleMaxText];

    [[self object] takeSnapBackValueFrom:snapBackValueText];
    [[self object] takeSnapsBackFromSwitch:snapsBackSwitch];

    [[self object] takeAbsoluteMinFrom:absoluteMinText];
    [[self object] takeAbsoluteMaxFrom:absoluteMaxText];
    [[self object] takeAbsoluteModeFromMatrix:absoluteModeMatrix];

    [[self object] takeDashIntervalFrom:dashIntervalText];
    [[self object] takeShowMainDashFromSwitch:showMainDashSwitch];

    [[self object] takeColorFrom:colorWell];

    [[self object] takeTagFrom:tagText];
    [[self object] takeDisabledFromSwitch:disabledSwitch];

    [[self object] setNeedsDisplay:YES];

    [super ok:sender];
}

- (void)revert:(id)sender
{
    [super revert:sender];

    [displayModeMatrix selectCellAtRow:[[self object] displayMode] column:0];
    [directionMatrix selectCellAtRow:[[self object] direction] column:0];

    [visibleMinText setFloatValue:[[self object] visibleMin]];
    [visibleMaxText setFloatValue:[[self object] visibleMax]];
    [currentText setFloatValue:[[self object] floatValue]];

    [snapBackValueText setFloatValue:[[self object] snapBackValue]];
    [snapsBackSwitch setState:[[self object] snapsBack]];

    [absoluteMinText setFloatValue:[[self object] absoluteMin]];
    [absoluteMaxText setFloatValue:[[self object] absoluteMax]];
    [absoluteModeMatrix selectCellAtRow:[[self object] absoluteMode] column: 0];

    [dashIntervalText setFloatValue:[[self object] dashInterval]];
    [showMainDashSwitch setState:[[self object] showMainDash]];

    [colorWell setTarget:NULL];
    [colorWell setColor:[[self object] color]];
    [colorWell setTarget:self];

    [tagText setIntValue:[[self object] tag]];
    [disabledSwitch setState:![[self object] isEnabled]];
}

- (BOOL)wantsButtons { return NO; }

@end