#import <AppKit/AppKit.h>

@class TWCell;

@interface ThumbWheel : NSControl
{
}

+ (void) setCellClass:(Class)factoryId;
- initWithFrame:(NSRect)f;

// Direction: vertical or horizontal
- (int)direction;
- (void)setDirection:(int)dir;
- (void)takeDirectionFromMatrix:sender;
- (BOOL)isVertical;
- (void)setVertical;
- (BOOL)isHorizontal;
- (void)setHorizontal;

// DisplayMode: radial or linear
- (int)displayMode;
- (void)setDisplayMode:(int)mode;
- (void)takeDisplayModeFromMatrix:sender;
- (void)toggleDisplayMode:sender;
- (BOOL)isRadial;
- (void)setRadial;
- (BOOL)isLinear;
- (void)setLinear;

// Visible min and max
- (float)visibleMax;
- (void)setVisibleMax:(float)max;
- (void)takeVisibleMaxFrom:sender;
- (float)visibleMin;
- (void)setVisibleMin:(float)min;
- (void)takeVisibleMinFrom:sender;
- (float)visibleRange;
- (float)middleValue;

// Absolute mode: unbounded, bounded or wrapped
- (int)absoluteMode;
- (void)takeAbsoluteModeFromMatrix:sender;
- (void)setAbsoluteMode:(int)mode;
- (BOOL)isUnbounded;
- (void)setUnbounded;
- (BOOL)isBounded;
- (void)setBounded;
- (BOOL)isWrapped;
- (void)setWrapped;
- (float)absoluteMax;
- (void)setAbsoluteMax:(float)value;
- (void)takeAbsoluteMaxFrom:sender;
- (float)absoluteMin;
- (void)setAbsoluteMin:(float)value;
- (void)takeAbsoluteMinFrom:sender;
- (float)absoluteRange;

// Relative Values
- (int)relativeIntValue;
- (float)relativeFloatValue;
- (void)resetRelativeValue;

// Snap back characteristic
- (BOOL)snapsBack;
- (void)setSnapsBack:(BOOL)flag;
- (void)takeSnapsBackFromSwitch:sender;
- (float)snapBackValue;
- (void)setSnapBackValue:(float)val;
- (void)takeSnapBackValueFrom:sender;

// Dash interval (set in degrees or points depending on displayMode)
- (float)dashInterval;
- (void)setDashInterval:(float)val;
- (void)takeDashIntervalFrom:sender;

// Showing the main dash
- (BOOL)showMainDash;
- (void)setShowMainDash:(BOOL)flag;
- (void)takeShowMainDashFromSwitch:sender;

// Color of the ThumbWheel
- (NSColor *)color;
- (void)setColor:(NSColor *)color;
- (void)takeColorFrom:(id)sender;

// tag and disabled
- (void)takeTagFrom:sender;
- (void)takeDisabledFromSwitch:sender;

@end

