#import "ThumbWheel.h"
#import "TWCell.h"

static id TWCellClass = nil;

/******************************************************************************
    ThumbWheel - by Jeff Martin
    
    ThumbWheel offers the functionality of Slider plus the features that you would expect from a real thumbwheel (including 2 3/4 D Graphics!).

    ThumbWheel has a linear display mode and a radial display mode and offers the ability to assign a value to the visible region of the control as well as an absolute value that the ThumbWheel will either ignore, bound to or wrap around.

    ThumbWheel can also return relative values via its -relativeIntValue & -relativeFloatValue methods. A snap back option allows mouse loops to start from and return to a base value.

Written by: Jeff Martin (jmartin@reportmill.com)
You may freely copy, distribute and reuse the code in this example.  
Don't even talk to me about warranties.
******************************************************************************/

@implementation ThumbWheel : NSControl

+ (void)setCellClass:(Class)factoryId { TWCellClass = factoryId; }

- initWithFrame:(NSRect)rect
{
  [super initWithFrame:rect];
  if(TWCellClass) [self setCell:[[TWCellClass alloc] init]];
  else [self setCell:[[TWCell alloc] init]];
  return self;
}

// Direction: vertical or horizontal
- (int)direction { return [[self cell] direction]; }
- (void)setDirection:(int)dir { [[self cell] setDirection:dir]; [self setNeedsDisplay:YES]; }
- (void)takeDirectionFromMatrix:sender { [[self cell] setDirection:[sender selectedTag]]; }
- (BOOL)isVertical { return [(ThumbWheel *)[self cell] isVertical]; }
- (void)setVertical { [[self cell] setVertical]; }
- (BOOL)isHorizontal { return [[self cell] isHorizontal]; }
- (void)setHorizontal { [[self cell] setHorizontal]; }

// DisplayMode: radial or linear
- (int)displayMode { return [[self cell] displayMode]; }
- (void)setDisplayMode:(int)mode { [[self cell] setDisplayMode:mode]; [self setNeedsDisplay:YES]; }
- (void)takeDisplayModeFromMatrix:sender { [[self cell] setDisplayMode:[sender selectedTag]]; }
- (void)toggleDisplayMode:sender { [[self cell] setDisplayMode:![[self cell] displayMode]]; }
- (BOOL)isRadial { return [[self cell] isRadial]; }
- (void)setRadial { [[self cell] setRadial]; }
- (BOOL)isLinear { return [[self cell] isLinear]; }
- (void)setLinear { [[self cell] setLinear]; }

// Visible min and max
- (float)visibleMax { return [[self cell] visibleMax]; }
- (void)setVisibleMax:(float)max { [[self cell] setVisibleMax:max]; [self setNeedsDisplay:YES]; }
- (void)takeVisibleMaxFrom:sender { [[self cell] setVisibleMax:[sender floatValue]]; }
- (float)visibleMin { return [[self cell] visibleMin]; }
- (void)setVisibleMin:(float)min { [[self cell] setVisibleMin:min]; [self setNeedsDisplay:YES]; }
- (void)takeVisibleMinFrom:sender { [[self cell] setVisibleMin:[sender floatValue]]; }
- (float)visibleRange { return [[self cell] visibleRange]; }
- (float)middleValue { return [[self cell] middleValue]; }

// Absolute mode: unbounded, bounded or wrapped
- (int)absoluteMode { return [[self cell] absoluteMode]; }
- (void)setAbsoluteMode:(int)mode { [[self cell] setAbsoluteMode:mode]; [self setNeedsDisplay:YES]; }
- (void)takeAbsoluteModeFromMatrix:sender { [[self cell] setAbsoluteMode:[sender selectedTag]]; }
- (BOOL)isUnbounded { return [[self cell] isUnbounded]; }
- (void)setUnbounded { [[self cell] setUnbounded]; }
- (BOOL)isBounded { return [[self cell] isBounded]; }
- (void)setBounded { [[self cell] setBounded]; }
- (BOOL)isWrapped { return [[self cell] isWrapped]; }
- (void)setWrapped { [[self cell] setWrapped]; }
- (float)absoluteMax { return [[self cell] absoluteMax]; }
- (void)setAbsoluteMax:(float)value { [[self cell] setAbsoluteMax:value]; }
- (void)takeAbsoluteMaxFrom:sender { [[self cell] setAbsoluteMax:[sender floatValue]]; }
- (float)absoluteMin { return [[self cell] absoluteMin]; }
- (void)setAbsoluteMin:(float)value { [[self cell] setAbsoluteMin:value]; }
- (void)takeAbsoluteMinFrom:sender { [[self cell] setAbsoluteMin:[sender floatValue]]; }
- (float)absoluteRange { return [[self cell] absoluteRange]; }

// Relative Values
- (int)relativeIntValue { return [[self cell] relativeIntValue]; }
- (float)relativeFloatValue { return [[self cell] relativeFloatValue]; }
- (void)resetRelativeValue { [[self cell] resetRelativeValue]; }

// Snap back characteristic
- (BOOL)snapsBack { return [[self cell] snapsBack]; }
- (void)setSnapsBack:(BOOL)flag { [[self cell] setSnapsBack:flag]; [self setNeedsDisplay:YES]; }
- (void)takeSnapsBackFromSwitch:sender { [[self cell] setSnapsBack:[sender state]]; }
- (float)snapBackValue { return [[self cell] snapBackValue]; }
- (void)setSnapBackValue:(float)val { [[self cell] setSnapBackValue:val]; [self setNeedsDisplay:YES]; }
- (void)takeSnapBackValueFrom:sender { [[self cell] setSnapBackValue:[sender floatValue]]; }

// Dash interval (set in degrees or points depending on displayMode)
- (float)dashInterval { return [[self cell] dashInterval]; }
- (void)setDashInterval:(float)val { [[self cell] setDashInterval:val]; [self setNeedsDisplay:YES]; }
- (void)takeDashIntervalFrom:sender { [[self cell] setDashInterval:[sender floatValue]]; }

// Showing the main dash
- (BOOL)showMainDash { return [[self cell] showMainDash]; }
- (void)setShowMainDash:(BOOL)flag { [[self cell] setShowMainDash:flag]; [self setNeedsDisplay:YES]; }
- (void)takeShowMainDashFromSwitch:sender { [[self cell] setShowMainDash:[sender state]]; }

// Color of the ThumbWheel
- (NSColor *)color { return [[self cell] color]; }
- (void)setColor:(NSColor *)color { [[self cell] setColor:color]; [self setNeedsDisplay:YES]; }
- (void)takeColorFrom:sender { [self setColor:[sender color]]; }

// tag and disabled
- (void)takeTagFrom:sender { [self setTag:[sender intValue]]; }
- (void)takeDisabledFromSwitch:sender { [self setEnabled:![sender state]]; }

- (NSString *)inspectorClassName { return @"TWInspector"; }
- (BOOL)isOpaque { return YES; }
- (BOOL)acceptsFirstResponder { return NO; }
- (BOOL)acceptsFirstMouse:(NSEvent *)theEvent { return YES; }

@end