#import "poker.h"
#import "IRCTask.h"

@implementation AppDelegate

- (NSString *)userName {
   NSString *s = [[NSUserDefaults standardUserDefaults] objectForKey:@"Name"];
   if (!s) return @"";
   return s;
}

- (PokerTable *)currentTable
{
    return currentTable;
}


- (id)sharedInstanceOfClassName:(NSString *)name
{
    id obj = nil;
    NSString *path = [[NSBundle mainBundle] pathForResource:name ofType:@"bundle"];
    if (path) {
        NSBundle *b = [[NSBundle allocWithZone:NULL] initWithPath:path];
        if ((b != nil) && ([b principalClass] !=NULL)) {
                obj = [[b principalClass] sharedInstance];
        } else NSLog(@"Can't Load %@!\n", path);
    } else NSLog(@"Couldn't find %@ bundle!\n",name);
    return obj;
}

- (IBAction)showPreferences:(id)sender {
    [[self sharedInstanceOfClassName:@"Preferences"] showWindow:self];
}

- (void)setCurrentTable:(PokerTable *)table;
{
     currentTable = table;
}

- (void)newTable:(id)sender
{
    currentTable = [[NSDocumentController sharedDocumentController] openUntitledDocumentOfType:@"Poker" display:YES];
}

- (IBAction)goOnVacation:sender {
    [[IRCTask sharedIRCTask] goOnVacation];
}

- (IBAction)returnFromVacation:sender {
    [[IRCTask sharedIRCTask] returnFromVacation];
}

- (void)applicationDidFinishLaunching:(NSNotification *)notification {
     NSString *user = [self userName];
    currentTable = [[[NSDocumentController sharedDocumentController] documents] objectAtIndex:0];
    if (!user || [user isEqualToString:@""]) {
	NSRunAlertPanel(@"Poker Nickname",@"You have not yet set your poker nickname - please enter a short name in the Preferences panel, then select Join Table (Command-J)",@"You Bet!",NULL,NULL);
        [self showPreferences:self];
    } else {
        [self makeConnectionAndJoinTable:self];
    }
    [currentTable setStatusString:@"You may need to select Join Table"];
}

- (void)applicationWillFinishLaunching:(NSNotification *)notification {
    NSMutableDictionary *dict = [NSMutableDictionary dictionary];
    [dict setObject:@"" forKey:@"Name"];
    [[NSUserDefaults standardUserDefaults] registerDefaults:dict];
}

- (void)leaveTable:(id)sender {
    [[IRCTask sharedIRCTask] leaveTable];
}

- (void)joinTable:(id)sender {
    [[IRCTask sharedIRCTask] joinTable];
}

- (void)makeConnectionAndJoinTable:(id)sender {
    [[IRCTask sharedIRCTask] makeIRCConnection:currentTable];
    [self joinTable:self];
}

@end
