#import <AppKit/AppKit.h>

typedef enum {
   Clubs = 1,
   Spades,
   Hearts,
   Diamonds
} Suit;

typedef enum {
    Ace = 0,
    King,
    Queen,
    Jack,
    Ten,
    Nine,
    Eight,
    Seven,
    Six,
    Five,
    Four,
    Trey,
    Deuce,
} Rank;


@interface Card : NSObject <NSCopying>
{
    Suit suit;
    Rank rank;
}

+ cardWithSuit:(Suit)aSuit rank:(Rank)rank;

- initSuit:(Suit)aSuit rank:(Rank)rank;

+ (NSImage *)imageForCard:(Card *)card;

- (Suit)suit;
- (int)rank;
- (NSImage *)image;

@end
