#import "poker.h"

@implementation Player


- (id)initWithName:(NSString *)name pokerTable:(PokerTable *)pokerTable
{
    self = [super init];
    table = pokerTable;
    playerName = [name copyWithZone:[self zone]];
    [self setIsMe:[[[NSApp delegate] userName] isEqualToString:playerName]];
    [self getNewHand];
    return self;
}

- (void)dealloc {
    [playerName release];
    [super dealloc];
}

- (NSString *)specialStatus {
    if (hasFolded) {
        if (onVacation) return @"\nFolded\nVacation";
	return @"\nFolded";
    } else if (onVacation) return @"\nVacation";
    else if ([table isButtonPlayer:self]){
        if (onVacation) return @"\nB\nVacation";
        if (hasFolded) return @"\nB\nFolded";
        return @"\nB";
    }
    else return @"";
}

- (BOOL)isMe {
   return isMe;
}

- (void)setIsMe:(BOOL)isOwner {
   isMe = isOwner;
}


- (NSString *)buttonTitle // a formatted string with player name and amount and status
{
    return [NSString stringWithFormat:@"%@\n$ %d%@",playerName,stack,[self specialStatus]];
}

- (NSString *)playerName {
   return playerName;
}

- (void)fold
{
    hasFolded = YES;
}

- (BOOL)hasFolded {
    return hasFolded;
}

- (BOOL)onVacation {
    return onVacation;
}

- (void)setOnVacation:(BOOL)isOwner
{
    onVacation = isOwner;
}

- (int)column
{
    return column;
}

- (void)setColumn:(int)aCol
{
    column = aCol;
}

- (int)row
{
    return row;
}


- (void)setRow:(int)aRow
{
    row = aRow;
}

- (HoldEmHighHoleHand *)holeHand
{
    return holeHand;
}

// call at new game:
- (void)getNewHand;
{
   [holeHand release];
   hasFolded = NO;
    holeHand = [[HoldEmHighHoleHand allocWithZone:[self zone]] init];
}

- (void)setStackAmount:(int)amount
{
    stack = amount;
}

- (int)stackAmount
{
    return stack;
}

@end
