// PokerTable.h

#import <AppKit/AppKit.h>
@class Player, Card, HoldEmHighHand, PotManager;

@interface PokerTable : NSDocument {
   IBOutlet NSMatrix *playersMatrix;  // 23 folks around the table
				      // the inner rows are transparent
   IBOutlet NSMatrix *publicCardsMatrix;  // 5 of them
   IBOutlet NSMatrix *holeCardsMatrix;	// 2 of them
   IBOutlet NSMatrix *raiseMatrix;	
   IBOutlet NSMatrix *foldCallMatrix;	
   IBOutlet NSTextField *raiseSpecifiedField;
   IBOutlet NSTextField *statusField;
   IBOutlet PotManager *myPot;
   IBOutlet PotManager *thePot;
   NSButtonCell *oldCell;
   NSRect oldRect;

    NSMutableArray *players;	// list of players
    Player *buttonPlayer;	// current Button player
    Player *currentPlayer;	// current player
    HoldEmHighHand *hand;	// 5 cards to be turned in turn
    BOOL hasInitedPlayers;

}

// ui methods:
- (IBAction)privateMessagePlayerAction:(id)sender; // click on a player to send message
- (IBAction)publicMessagePlayerAction:(id)sender; // send message to all
- (IBAction)foldAction:(id)sender;
- (IBAction)callAction:(id)sender;
- (IBAction)raisePotAction:(id)sender;
- (IBAction)raiseHalfPotAction:(id)sender;
- (IBAction)raiseMaximumAction:(id)sender;
- (IBAction)raiseMinimumAction:(id)sender;
- (IBAction)raiseSpecifiedAmountAction:(id)sender;

// hooks for cliff
- (void)newPokerTable;   // to start over fresh (or should we make new window??)

// call before each new game
- (void)newHand;  

// call this in order of players
// we can add an index if you prefer!
- (void)addPlayer:(const char *)player cash:(int)amount;
- (void)player:(const char *)player hasCash:(int)amount;

// when done adding players, call this:
- (void)beginAddingPlayers;
- (void)readyToBeginGame;

// when a public card is turned...
- (void)publicCardNumber:(int)indexOfCard didShowCard:(Card *)card;

// show down:
- (IBAction)seeHoleCardsOfPlayer:(const char *)player;

- (Player *)findPlayerWithName:(const char *)playerName;
- (void)deletePlayer:(const char *)player;
- (void)setButtonPlayer:(const char *)playerName;
- (void)setPlayersTurn:(const char *)playerName;
- (void)userGotFirstHoleCard:(Card *)card secondCard:(Card *)card;

- (BOOL)isButtonPlayer:(Player *)player;
- (void)setStatusString:(NSString *)message;

/* start of crap added by Cliff */

- (HoldEmHighHand *) hand;
- (void)player:(const char *)player messages:(const char *)message;

- (void)playerQuits:(const char *) player n_left:(int)nleft;
- (void)tourneyStarted;
- (void)blindsAre:(int) small_blind and:(int) big_blind;
- (void)player:(const char *)player toCall:(int)to_call;
- (void)player:(const char *)player blinds:(int)blind potNow:(int)pot allIn:(BOOL)allIn;
- (void) blindsWillDoubleIn:(int)blind_remaining units:(const char *)blind_remaining_units;
- (void) beginHand:(int)hand_no n_players:(int)n_players;
- (void) player:(const char *)player foldsLeaving:(int)n_players;
- (void) player:(const char *)player calls:(int)amount potNow:(int)pot allIn:(BOOL)allIn;
- (void) player:(const char *)player vacationedBy:(const char *)by_whom;
- (void) playerChecks:(const char *)player;
- (void) player:(const char *)player bets:(int)amount potNow:(int)pot allIn:(BOOL)allIn;
- (void) playerBackFromVacation:(const char *)player;
- (void) player:(const char *)player wins:(int) amount withHand:(const char *)hand;
- (void) aboutToShowHands;
- (void) player:(const char *)player raises:(int)amount potNow:(int)pot allIn:(BOOL)allIn;
- (void) playerBusted:(const char *)player;
- (void) playerQuit:(const char *)player;
/* end of Cliff crap */


@end

#define NUM_PLAYERS_COLS	7
#define NUM_PLAYERS_ROWS	7
#define NUM_POSSIBLE_PLAYER_CELLS 24
#define USER_ROW	6
#define USER_COL	3

