/*
	Copyright 1995, Anderson Financial Systems Inc.  All Rights Reserved.
	Anderson Financial Systems, Inc.
	909 Sumneytown Pike, Suite 106
	Springhouse, PA 19477
	215 653 0911
 */

/* Paragraphs consist of a list of word objects. Spaces are assumed after most
 * word objects. Be sure to recompute the paragraph anytime you change a word.
 */
 
#import "ParagraphAccess_Protocol.h"

@protocol WordAccess

	/* Tabs are special words, so are merge tokens, Time/Date fields, etc. 
	 * the only special word you can insert now is a Page Break and a Page 
	 * Number.
	 */
- (BOOL)isSpecial;
- (BOOL)isSpecialType:(int)aWordType;
- (int)wordType;

	/* language Id for words. see constants section. */
- setLangId:(short)newId;
- (short)langId;
- (int)length;

	/* setting and getting the text in a word.*/
- setText:(const char *)theText;
- (const char *)text;
- (const char *)charAtIndex:(int)idx;

	/* which paragraph object does this word belong to. */
- paragraph;

	/* Returns insert point for the word.*/
- (int)insertPoint;
	
	/* sets the insert point for the word.*/
- setInsertPoint:(int)newPoint;
- setInsertToEnd;
- setInsertToStart;

@end
