/*
	Copyright 1995, Anderson Financial Systems Inc.  All Rights Reserved.
	Anderson Financial Systems, Inc.
	909 Sumneytown Pike, Suite 106
	Springhouse, PA 19477
	215 653 0911
 */
#import "WriteUpDocumentAccess_Protocol.h"

@protocol WriteUpRemoteApp

	/* Returns the active document, nil if no documents open
	 */
- (id <WUDocument>)activeDocument;

	/* Returns an already open document whose name is aName.
	 */
- (id <WUDocument>)documentNamed:(NSString *)aName;

	/* Creates a new document, using the user's default New From Template
	 * document. yn visible/invisible
	 */
- (id <WUDocument>)newEmptyDocumentIsVisible:(BOOL)yn;

	/* Performs newEmptyDocumentIsVisible:YES
	 */
- (id <WUDocument>)newEmptyDocument;

	/* Opens the file specified by path.  yn visible/invisible
	 */
- (id <WUDocument>)openFromFile:(NSString *)path 
	isVisible:(BOOL)yn;
	
	/* Opens the template specified by path, and creates a new, 
	 * untitled document from that template. yn visible/invisible
	 */
- (id <WUDocument>)newFromTemplate:(NSString *)path 
	isVisible:(BOOL)yn;

@end
