/*
    File:       Hockey.m

    Contains:	Code for hockey game object

    Written by: Michelle Wyner

    Created:    October 1997

    Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

    Change History (most recent first):
                 October 1997 - file created.
 
    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

#import "Hockey.h"

@implementation Hockey

- (id)init
{
  
  self = [super init];
  [self setAgainst:@""];
  [self setScore:@""];
  [self setOutcome:@""];
  return self;
}

- (void)dealloc
{
  [date release];
  [time release];
  [against release];
  [score release];
  [outcome release];

  [super dealloc];
}

- (void)setTime:(NSCalendarDate *)newTime
{
  if (time != newTime) {
    [time release];
    time = [newTime copyWithZone:[self zone]];
  }

}

- (NSCalendarDate *)time
{
    return time;
}


- (void)setDate:(NSCalendarDate *)newDate
{
  [date autorelease];
  date = [newDate copy];
}

- (NSCalendarDate *)date
{
    return date;
}


- (void)setAgainst:(NSString *)newAgainst
{
    newAgainst = [newAgainst copy];
    [against release];
    against = newAgainst;
}

- (NSString *)against
{
  return against;
}

- (void)setScore:(NSString *)newScore
{
    newScore = [newScore copy];
    [score release];
    score = newScore;
}

- (NSString *)score
{
  return score;
}

- (void)setOutcome:(NSString *)newOutcome
{
    newOutcome = [newOutcome copy];
    [outcome release];
    outcome = newOutcome;
}

- (NSString *)outcome
{
  return outcome;
}

@end
