// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OmniFoundation/OFSimpleLock.h,v 1.5 1998/12/08 04:07:52 kc Exp $

#ifndef	__TARGET_ARCHITECTURE__
#define	__TARGET_ARCHITECTURE__	__ARCHITECTURE__
#endif

#ifndef __TARGET_ARCHITECTURE__
#error Neither __TARGET_ARCHITECTURE__ nor __ARCHITECTURE__ was defined!
#endif

#if defined(NeXT_PDO) && !defined(WINNT)
#define	OMNI_ARCH_INCLUDE(headerName)	\
	#headerName "-pdo-" __TARGET_ARCHITECTURE__ ".h"

#else
#define	OMNI_ARCH_INCLUDE(headerName)	\
	#headerName "-" __TARGET_ARCHITECTURE__ ".h"
#endif

#if defined(__SVR4) && defined(sun)
// This goofiness with string appending doesn't work on Solaris
#import "OFSimpleLock-pdo-sparc.h"
#else
#import OMNI_ARCH_INCLUDE(OFSimpleLock)
#endif




#ifndef OFSimpleLockDefined
#define OFSimpleLockDefined

#import <mach/cthreads.h>

typedef struct mutex OFSimpleLockType;

static inline void OFSimpleLockInit(OFSimpleLockType *simpleLock)
{
    mutex_init(simpleLock);
}

static inline void OFSimpleLockFree(OFSimpleLockType *simpleLock)
{
    mutex_clear(simpleLock);
}

static inline void OFSimpleLock(OFSimpleLockType *simpleLock)
{
    mutex_lock(simpleLock);
}

static inline void OFSimpleLockTry(OFSimpleLockType *simpleLock)
{
    mutex_try_lock(simpleLock);
}

static inline void OFSimpleUnlock(OFSimpleLockType *simpleLock)
{
    mutex_unlock(simpleLock);
}

#endif
