// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "NSCalendarDate-OFExtensions.h"

#import <Foundation/Foundation.h>

@implementation NSCalendarDate (OFExtensions)

static NSCalendarDate *unixReferenceDate = nil;
static int thisYear;

+ (NSCalendarDate *)unixReferenceDate;
{
    const long zero = 0;

    return [NSCalendarDate dateWithString:[NSString stringWithCString:ctime(&zero)] calendarFormat:@"%a %b %d %H:%M:%S %Y\n"];
}

- (void)setToUnixDateFormat;
{
    if ([self yearOfCommonEra] == [(NSCalendarDate *)[NSCalendarDate date] yearOfCommonEra])
	[self setCalendarFormat:@"%b %d %H:%M"];
    else
	[self setCalendarFormat:@"%b %d %Y"];
}

- initWithTime_t:(int)time;
{
    NSCalendarDate *date;

    date = (id)[self initWithTimeInterval:time sinceDate:[isa unixReferenceDate]];
    [date setToUnixDateFormat];
    return date;
}

@end
