// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OFIObjectSelectorObjectObject.h"

#import <Foundation/Foundation.h>
#import <objc/objc-class.h>
#import <OmniBase/OmniBase.h>

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OmniFoundation/Scheduling.subproj/OFIObjectSelectorObjectObject.m,v 1.5 1998/12/08 04:08:29 kc Exp $")

@implementation OFIObjectSelectorObjectObject;

static Class myClass;

+ (void)initialize;
{
    static BOOL initialized = NO;

    [super initialize];
    if (initialized)
	return;
    initialized = YES;

    myClass = self;
}

- initForObject:(id)anObject selector:(SEL)aSelector withObject:(id)aWithObject withObject:(id)andAnotherObject;
{
    OBPRECONDITION([anObject respondsToSelector: aSelector]);

    [super initForObject:anObject];
    selector = aSelector;
    withObject = [aWithObject retain];
    anotherObject = [andAnotherObject retain];
    return self;
}

- (void)dealloc;
{
    [withObject release];
    [anotherObject release];
    [super dealloc];
}

- (void)invoke;
{
    Method method;

    method = class_getInstanceMethod(((OFIObjectSelectorObjectObject *) object)->isa, selector);
    if (!method)
        [NSException raise:NSInvalidArgumentException format:@"%@ does not respond to the selector %@", object, NSStringFromSelector(selector)];

    method->method_imp(object, selector, withObject, anotherObject);
}

- (unsigned int)hash;
{
    return (unsigned int)object + (unsigned int)(void *)selector + (unsigned int)withObject + (unsigned int)anotherObject;
}

- (BOOL)isEqual:(id)anObject;
{
    OFIObjectSelectorObjectObject *otherObject;

    otherObject = anObject;
    if (otherObject->isa != myClass)
	return NO;
    return object == otherObject->object && selector == otherObject->selector && withObject == otherObject->withObject && anotherObject == otherObject->anotherObject;
}

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];
    if (object)
	[debugDictionary setObject:object forKey:@"object"];
    [debugDictionary setObject:NSStringFromSelector(selector) forKey:@"selector"];
    if (withObject)
	[debugDictionary setObject:withObject forKey:@"withObject"];
    if (anotherObject)
	[debugDictionary setObject:anotherObject forKey:@"anotherObject"];

    return debugDictionary;
}

- (NSString *)shortDescription;
{
    return [NSString stringWithFormat:@"-[%@ %@(%@,%@)]", OBShortObjectDescription(object), NSStringFromSelector(selector), OBShortObjectDescription(withObject), OBShortObjectDescription(anotherObject)];
}

@end
