// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OFResultHolder.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OmniFoundation/Scheduling.subproj/OFResultHolder.m,v 1.2 1998/12/08 04:08:32 kc Exp $")

@implementation OFResultHolder

- init
{
    self = [super init];
    theResult = nil;
    lock = [[NSConditionLock alloc] initWithCondition:NO];
    return self;
}

- (void)dealloc
{
    [theResult release];
    theResult = nil;
    [lock release];
    lock = nil;
    [super dealloc];
}

- (void)setResult:anObject
{
    [lock lock];
    [anObject retain];
    [theResult release];
    theResult = anObject;
    [lock unlockWithCondition:YES];
}

- (id)getResult
{
    id result;
    [lock lockWhenCondition:YES];
    result = [theResult retain];
    [lock unlock];
    return [result autorelease];
}

@end
