/* PBButtons.m created by pekeler on Sat 08-Aug-1998 */

#import "PBButtons.h"
#import "PBMakeButtons.h"
#import "PBLaunchButtons.h"
#import "PBButtonsPreferencesController.h"
#import "objc/objc-class.h"

@implementation NSButton (NotificationHack)

- (void)setEnabled:(BOOL)flag
{
    [super setEnabled:flag];
    if ([[[self image] name] isEqualToString:@"processes"]
        && [[self window] delegate]
        && [NSStringFromClass([[[self window] delegate] class]) isEqualToString:@"Launcher"])
    {
        [[NSNotificationCenter defaultCenter] postNotificationName:LAUNCH_BUTTON_NOTIFICATION_NAME
                                                            object:self];
    }
    else if ([self action]
             && ([NSStringFromSelector([self action]) isEqualToString:@"make:"]
                 || [NSStringFromSelector([self action]) isEqualToString:@"makeClean:"]))
    {
        [[NSNotificationCenter defaultCenter] postNotificationName:MAKE_BUTTON_NOTIFICATION_NAME
                                                            object:self];
    }
}

@end

@implementation PBButtons

+ (void)initialize
{
    [PBButtonsPreferencesController registerDefaults];
    [PBLaunchButtons sharedInstance];
    [PBMakeButtons sharedInstance];
}

- (NSString *)buttonNotificationName
{
    return @"";
}

- (id)init
{
    if ([super init])
    {
        buttonsPerWindow = [[NSMutableDictionary alloc] init];
        [[NSNotificationCenter defaultCenter] addObserver:self
                                                 selector:@selector(windowOpened:)
                                                     name:NSWindowDidBecomeKeyNotification
                                                   object:nil];
        [[NSNotificationCenter defaultCenter] addObserver:self
                                                 selector:@selector(sourceButtonChangedEnabled:)
                                                     name:[self buttonNotificationName]
                                                   object:nil];
        return self;
    }
    return nil;
}

- (void)sourceButtonChangedEnabled:(NSNotification *)notification
{
    NSArray			*buttons;
    NSEnumerator	*buttonEnum;
    NSButton		*sourceButton;
    NSButton		*button;
    NSView			*view;
    BOOL			sourceButtonIsEnabled;

    sourceButton = [notification object];
    if (!(view = [[sourceButton window] contentView]))	// Launchbuttons
    {
        view = [[[[[sourceButton superview] superview] superview] superview] superview];	// Makebuttons
    }
    if (buttons = [buttonsPerWindow objectForKey:[NSValue valueWithPointer:view]])
    {
        sourceButtonIsEnabled = [sourceButton isEnabled];
        buttonEnum = [buttons objectEnumerator];
        while (button = [buttonEnum nextObject])
        {
            [button setEnabled:sourceButtonIsEnabled];
        }
    }
}

- (NSString *)instanceVariableNameOfOriginalView
{
    return @"";
}

- (id)originalViewForWindow:(NSWindow *)aWindow
{
    id <Maker_PBButtons>	maker;
    id						originalView = nil;

    maker = [aWindow delegate];
    object_getInstanceVariable(maker,
                               [[self instanceVariableNameOfOriginalView] cString],
                               (void **)&originalView);
    return originalView;
}

- (void)removeAllButtons
{
    NSEnumerator	*buttonPerWindowKeyEnum;
    NSValue			*key;

    buttonPerWindowKeyEnum = [buttonsPerWindow keyEnumerator];
    while (key = [buttonPerWindowKeyEnum nextObject])
    {
        NSArray	*buttons;

        buttons = [buttonsPerWindow objectForKey:key];
        if (buttons
            && [buttons count])
        {
            NSEnumerator	*buttonEnum;
            NSButton		*button;

            buttonEnum = [buttons objectEnumerator];
            while (button = [buttonEnum nextObject])
            {
                [button removeFromSuperview];
            }
        }

    }
    [buttonsPerWindow removeAllObjects];
}

- (void)createButtonsInWindow:(NSWindow *)window
{
}

- (NSString *)centralPBClassName
{
    return @"";
}

- (void)restoreNextKeyViewChainForWindow:(NSWindow *)aWindow
{
}

- (void)windowOpened:(NSNotification *)notification
{
    NSWindow	*window;

    window = [notification object];
    if ([window delegate]
        && [NSStringFromClass([[window delegate] class]) isEqualToString:[self centralPBClassName]]
        && ([[window delegate] window] == window))
    {
        if (![buttonsPerWindow objectForKey:[NSValue valueWithPointer:[window contentView]]])
        {
            [self createButtonsInWindow:window];
        }
        [self restoreNextKeyViewChainForWindow:window];
    }
}

@end
