/* PBMakeButtons.m created by pekeler on Fri 07-Aug-1998 */

#import "PBMakeButtons.h"
#import "PBButtonsPreferencesController.h"
#import "objc/objc-class.h"

static PBMakeButtons	*sharedInstanceGV = nil;

@implementation PBMakeButtons

+ (id)sharedInstance
{
    if (!sharedInstanceGV)
    {
        sharedInstanceGV = [self new];
    }
    return sharedInstanceGV;
}

- (NSString *)buttonNotificationName
{
    return MAKE_BUTTON_NOTIFICATION_NAME;
}

- (void)buttonAction:(id)sender
{
    id <Maker_PBButtons>	maker;
    NSPopUpButton			*targetPopUpBU;
    NSString				*targetString;

    maker = [[sender window] delegate];
    object_getInstanceVariable(maker,
                               "targetPopUp",
                               (void **)&targetPopUpBU);
    targetString = [sender toolTip];
    [targetPopUpBU addItemWithTitle:targetString];
    [targetPopUpBU selectItemWithTitle:targetString];
    [maker switchTarget:targetPopUpBU];
    [maker build];
}

- (NSString *)instanceVariableNameOfOriginalView
{
    return @"buildButton";
}

- (void)resizeWindow:(NSWindow *)aWindow makeItTaller:(BOOL)makeItTaller
{
    NSRect		originalButtonFrame;
    NSRect		windowFrame;
    BOOL		autoresizesSubviews;
    float		heightDiff;
    NSButton	*originalButton;
    NSRect		buttonFrame;
    NSView		*contentView;

    contentView = [aWindow contentView];
    originalButton = [self originalViewForWindow:aWindow];
    originalButtonFrame = [originalButton frame];
    buttonFrame = [originalButton convertRect:[originalButton bounds]
                                       toView:contentView];
    autoresizesSubviews = [contentView autoresizesSubviews];
    windowFrame = [aWindow frame];
    heightDiff = buttonFrame.size.height;
    windowFrame.size.height += (makeItTaller ? heightDiff : -heightDiff);
    [contentView setAutoresizesSubviews:NO];
    [aWindow setFrame:windowFrame
              display:NO];
    [contentView setAutoresizesSubviews:autoresizesSubviews];
    windowFrame.size.height -= (makeItTaller ? heightDiff : -heightDiff);
    [aWindow setFrame:windowFrame
              display:YES];
}

- (void)createButtonsInWindow:(NSWindow *)aWindow
{
    NSView	*contentView;
    id		originalButton;
    NSRect	buttonFrame;
    NSArray	*makeButtonDescriptions;

    contentView = [aWindow contentView];
    originalButton = [self originalViewForWindow:aWindow];
    buttonFrame = [originalButton convertRect:[originalButton bounds]
                                       toView:contentView];
    if (([contentView frame].size.height - buttonFrame.origin.y) > (2 * buttonFrame.size.height))	// What a kludge, but -removeAllButtons can only resize the current window.
    {
        [self resizeWindow:aWindow
              makeItTaller:NO];
        buttonFrame = [originalButton convertRect:[originalButton bounds]
                                           toView:contentView];
    }
    makeButtonDescriptions = [[PBButtonsPreferencesController sharedInstance] makeButtonDescriptions];
    if (makeButtonDescriptions
        && [makeButtonDescriptions count])
    {
        NSEnumerator	*buttonDescriptionEnum;
        NSDictionary	*buttonDescription;
        NSImage			*image;
        NSButton		*button;
        NSMutableArray	*buttons;

        [self resizeWindow:aWindow
              makeItTaller:YES];
        image = [[[NSImage alloc] initWithContentsOfFile:[[NSBundle bundleForClass:[self class]] pathForImageResource:@"OtherMake"]] autorelease];
        buttons = [[[NSMutableArray alloc] init] autorelease];
        buttonDescriptionEnum = [makeButtonDescriptions objectEnumerator];
        while (buttonDescription = [buttonDescriptionEnum nextObject])
        {
            button = [[[NSButton alloc] initWithFrame:buttonFrame] autorelease];
            [button setFont:[NSFont fontWithName:@"Helvetica"
                                            size:7]];
            [button setTitleWithMnemonic:[buttonDescription objectForKey:TITLE_KEY]];
            [button setToolTip:[buttonDescription objectForKey:TEXT_KEY]];
            [button setAutoresizingMask:(NSViewMaxXMargin + NSViewMinYMargin)];
            [button setTarget:self];
            [button setRefusesFirstResponder:NO];
            [button setAction:@selector(buttonAction:)];
            [button setImage:image];
            [button setImagePosition:NSImageOverlaps];
            [[button cell] setGradientType:NSGradientConcaveStrong];
            [button setEnabled:YES];
            [contentView addSubview:button];
            [buttons addObject:button];
            buttonFrame.origin.x += buttonFrame.size.width;
        }
        [contentView _recursiveSetDefaultKeyViewLoop];		// Is there public api for this?
        [buttonsPerWindow setObject:buttons
                             forKey:[NSValue valueWithPointer:contentView]];
    }
}

- (void)restoreNextKeyViewChainForWindow:(NSWindow *)aWindow
{
    NSButton	*lastButton;
    id			originalButton;

    originalButton = [self originalViewForWindow:aWindow];
    lastButton = [[buttonsPerWindow objectForKey:[NSValue valueWithPointer:[aWindow contentView]]] lastObject];
    [lastButton setNextKeyView:originalButton];
}

- (NSString *)centralPBClassName
{
    return @"Maker";
}

@end
