// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OFMultiValueDictionary.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OmniFoundation/DataStructures.subproj/OFMultiValueDictionary.m,v 1.4 1998/12/08 04:08:01 kc Exp $")

@implementation OFMultiValueDictionary

- init;
{
    if (![super init])
	return nil;

    dictionary = [[NSMutableDictionary alloc] init];

    return self;
}

- (void)dealloc;
{
    [dictionary release];
    [super dealloc];
}

- (NSArray *)arrayForKey:(NSString *)aKey;
{
    return [dictionary objectForKey:aKey];
}

- (id)firstObjectForKey:(NSString *)aKey;
{
    return [[dictionary objectForKey:aKey] objectAtIndex:0];
}

- (id)lastObjectForKey:(NSString *)aKey;
{
    return [[dictionary objectForKey:aKey] lastObject];
}

- (void)addObject:(id)anObject forKey:(NSString *)aKey;
{
    NSMutableArray *valueArray;

    valueArray = [dictionary objectForKey:aKey];
    if (!valueArray) {
	valueArray = [NSMutableArray arrayWithObject:anObject];
	[dictionary setObject:valueArray forKey:aKey];
    } else
	[valueArray addObject:anObject];
}

- (NSEnumerator *)keyEnumerator;
{
    return [dictionary keyEnumerator];
}

- (NSMutableDictionary *)dictionary;
{
    return dictionary;
}

// Debugging

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];
    if (dictionary)
	[debugDictionary setObject:dictionary forKey:@"dictionary"];
    return debugDictionary;
}

@end
