// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OmniFoundation/OFCondition.h,v 1.5 1998/12/08 04:07:44 kc Exp $

#import "OFObject.h"

#ifdef FAST_BUGGY_WAY
#import <mach/cthreads.h>
#endif

@class NSConditionLock;

@interface OFCondition : OFObject
{
#ifdef FAST_BUGGY_WAY
    struct condition machCondition;
    struct mutex machMutex;
    unsigned int signalCount;
#else
    NSConditionLock *lock;
    struct {
        unsigned int cleared:1;
    } flags;
#endif
}

- init;

- (void)waitForCondition;

- (void)signalCondition;
- (void)broadcastCondition;

- (void)clearCondition;

@end
