// Copyright 1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OmniFoundation/OFControllerNotifications.h,v 1.4 1998/12/08 04:07:44 kc Exp $

#import <Foundation/NSString.h>

#import "FrameworkDefines.h"

// The following notifications are posted during application initialization.  Classes can register for these notifications in their +didLoad methods (and those +didLoad methods probably shouldn't do much else, since defaults aren't yet registered during +didLoad).

OmniFoundation_EXTERN NSString *OFControllerDidInitNotification;
    // This notification is for setting up a class (reading defaults, etc.).  At this point it shouldn't rely on any other classes (except OFUserDefaults) being set up yet.
    // This notification is posted by the application delegate in -applicationWillFinishLaunching:.

OmniFoundation_EXTERN NSString *OFControllerStartRunningNotification;
    // This notification is for resetting the state of a class to the way it was when the user last left the program:  for instance, popping up a window that was open.
    // This notification is posted by the application delegate in -applicationDidFinishLaunching:.

// The following notifications are posted during application termination.

OmniFoundation_EXTERN NSString *OFControllerRequestsTerminateNotification;
    // This notification gives objects an opportunity to save documents, etc., when an application is considering terminating.
    // This notification is posted by the application delegate in -applicationShouldTerminate:.  See also OFControllerRequestsCancelTerminateNotification.

OmniFoundation_EXTERN NSString *OFControllerWillTerminateNotification;
    // This notification is posted by the application delegate just before returning YES to -applicationShouldTerminate: (in other words, just before the application terminates, when there's no chance that the termination will be cancelled).  This may be used to wait for a particular activity (e.g. an asynchronous document save) before the application finally terminates.

// The following exception can be raised during an OFControllerRequestsTerminateNotification.

OmniFoundation_EXTERN NSString *OFControllerRequestsCancelTerminateException;
    // This exception can be raised during an OFControllerRequestsTerminateNotification when an object wishes to cancel the termination (typically in response to a user pressing the "Cancel" button on a Save panel).  If this exception is raised, the application delegate will return NO to -applicationShouldTerminate:.
