// Copyright 1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OmniFoundation/OpenStepExtensions.subproj/NSNotificationCenter-OFExtensions.h,v 1.2 1998/12/08 04:08:20 kc Exp $

#import <Foundation/NSNotification.h>

@class NSArray;

@interface NSNotificationCenter (OFExtensions)

- (void)addObserver:(id)observer
           selector:(SEL)aSelector
               name:(NSString *)aName
            objects:(NSArray *)objects;
/* Convenience method for registering for the same notification from many objects. */

- (void)removeObserver:(id)observer
                  name:(NSString *)aName
               objects:(NSArray *)objects;
/* Convenience method for removing ourself for the same notification from many objects. */

@end
