/*
    File:       Controller.m

    Contains:   A simple application that uses NSTask.

    Written by: Quinn "The Eskimo!"

    Created:    23 Sep 1997

    Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

    Change History (most recent first):

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

#import "Controller.h"

@implementation Controller

- (void)awakeFromNib
    // After the class has been wired up properly,
    // interrogate the application's bundle to find
    // out the path to the application's code.  Then
    // put that path in the appPath field, where it
    // acts as a useful default for the NSTask launch.
{
    NSBundle *appBundle;
    NSString *appDir;
    NSString *appName;

    [mainWindow makeKeyAndOrderFront:self];
    appBundle = [NSBundle mainBundle];
    appDir = [appBundle bundlePath];
    appName = [[appBundle infoDictionary] objectForKey:@"NSExecutable"];
    [appPath setStringValue:[appDir stringByAppendingPathComponent:appName]];
}

- (void)doChoose:(id)sender
    // If the user clicks on the Choose button,
    // bring up a standard Open panel to allow them
    // to choose the task to launch.  Store the result
    // in the appPath field.
{
    NSOpenPanel *openPanel;
    int result;
    NSString *fileToOpen;

    openPanel = [NSOpenPanel openPanel];
    [openPanel setAllowsMultipleSelection:NO];
    result = [openPanel runModalForTypes:nil];
    if (result == NSOKButton) {
        fileToOpen = [[openPanel filenames] objectAtIndex:0];
        [appPath setStringValue:fileToOpen];
    }
}

- (void)doLaunch:(id)sender
    // If the user clicks on the Launch button, create
    // an NSTask, fill out its arguments from the
    // paramX fields, fill out the code to launch from
    // the appPath field, and then launch it and wait
    // for it to finish.
{
    NSTask *aTask;
    NSMutableArray *args;

    // Create the task.
    
    aTask = [[[NSTask alloc] init] autorelease];

    // Set the task's "current working directory"
    // by knocking the last component off the full path.
    
    [aTask setCurrentDirectoryPath:[[appPath stringValue]
            stringByDeletingLastPathComponent]];

    // Set the launch path, ie the path to the code to execute.
    
    [aTask setLaunchPath:[appPath stringValue]];

    // Create the arguments and put them into the task.

    args = [NSArray arrayWithObjects:
                    [param1 stringValue],
                    [param2 stringValue],
                    [param3 stringValue],
                    nil];
    [aTask setArguments:args];

    // Launch the task.
    
    [aTask launch];

    // And wait for it to finish.
    // Note that the wait for termination is necessary
    // because we autoreleased the task
    // (and hence it will be released when
    // when we returned from this routine to the main run
    // loop).  In some cases, the wait for termination is
    // inappropriate (because the task your launching is
    // Distributed Objects server, for example), in which
    // case you would not autorelease the NSTask, but instead
    // keep it around in some data structure.
    
    [aTask waitUntilExit];

    // Output the termination status.
    
    NSLog(@"Task terminated with status %d", [aTask terminationStatus]);
}

@end
