// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OWAbstractContent.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import "OWContentInfo.h"

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OWF/Content.subproj/OWAbstractContent.m,v 1.3 1998/12/08 04:05:37 kc Exp $")

@implementation OWAbstractContent

// Init and dealloc

- init;
{
    NSString *name;

    name = NSStringFromClass(isa);
    if ([name hasPrefix:@"OW"] || [name hasPrefix:@"OI"] || [name hasPrefix:@"OH"])
        name = [name substringFromIndex:2];

    return [self initWithName:name];
}

- initWithName:(NSString *)name;
{
    if (![super init])
        return nil;

    contentInfo = [[OWContentInfo alloc] initWithContent:self typeString:name];

    return self;
}

- (void)dealloc;
{
    [contentInfo nullifyContent];
    [contentInfo release];

    [super dealloc];
}


// OWContent protocol

- (OWContentType *)contentType;
{
    [self doesNotRecognizeSelector:_cmd];
    return nil;
}

- (OWContentInfo *)contentInfo;
{
    return contentInfo;
}


@end
