// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OWContentContainer.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import "OWContentInfo.h"
#import "OWContentType.h"

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OWF/Content.subproj/OWContentContainer.m,v 1.4 1998/12/08 04:05:39 kc Exp $")

@implementation OWContentContainer

+ (OWContentContainer *)containerWithContent:(id)someContent contentType:(OWContentType *)aContentType;
{
    return [[[self alloc] initWithContent:someContent contentType:aContentType] autorelease];
}

- initWithContent:(id <NSObject>)someContent contentType:(OWContentType *)aContentType;
{
    NSString *contentName;

    if ([content conformsToProtocol:@protocol(OWContent)])
        contentName = [[(id <OWContent>)content contentInfo] typeString];
    else
        contentName = [aContentType readableString];
    
    if (![super initWithName:contentName])
	return nil;

    content = [someContent retain];
    contentType = aContentType;

    return self;
}

- (void)dealloc;
{
    [content release];
    [super dealloc];
}

- (id)content;
{
    return content;
}

// OWContent protocol

- (OWContentType *)contentType;
{
    return contentType;
}

// OWOptionalContent protocol

- (OWCursor *)contentCursor;
{
    // Our NSObject(OWContent) category implements OWOptionalContent
    return [(id <OWOptionalContent>)content contentCursor];
}

- (unsigned long int)cacheSize;
{
    // Our NSObject(OWContent) category implements OWOptionalContent
    return [(id <OWOptionalContent>)content cacheSize];
}

- (BOOL)shareable;
{
    // Our NSObject(OWContent) category implements OWOptionalContent
    return [(id <OWOptionalContent>)content shareable];
}

- (BOOL)contentIsValid;
{
    // Our NSObject(OWContent) category implements OWOptionalContent
    return [(id <OWOptionalContent>)content contentIsValid];
}

// Debugging

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];

    if (contentType)
	[debugDictionary setObject:contentType forKey:@"contentType"];
    if (content)
	[debugDictionary setObject:content forKey:@"content"];

    return debugDictionary;
}

@end
