// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OWF/Content.subproj/OWDataStream.h,v 1.6 1998/12/08 04:05:40 kc Exp $

#import "OWStream.h"

@class NSConditionLock, NSData, NSFileHandle, NSLock, NSMutableData, NSRecursiveLock;
@class OFCondition;
@class OWContentCache, OWDataStreamCursor;

#import <Foundation/NSByteOrder.h>
#import <Foundation/NSString.h> // For NSStringEncoding

#define OWDataStreamBuffer_BufferedDataLength 8188

typedef struct _OWDataStreamBuffer {
    byte data[OWDataStreamBuffer_BufferedDataLength];
    struct _OWDataStreamBuffer *next;
} OWDataStreamBuffer;

@interface OWDataStream : OWStream
{
    OWContentType *contentEncoding;

    OFCondition *dataAvailableCondition;
    OFCondition *endOfDataCondition;

    OWDataStreamBuffer *first;
    OWDataStreamBuffer *last;
    unsigned int dataLength;
    unsigned int readLength;
    unsigned int dataInBuffer;

    NSStringEncoding stringEncoding;

    struct {
        unsigned int endOfData:1;
        unsigned int hasThrownAwayData:1;
        unsigned int hasIssuedCursor:1;
        unsigned int hasResetContentTypeAndEncoding:1;
    } flags;

    NSString *saveFilename;
    NSFileHandle *saveFileHandle;
    unsigned int savedInBuffer;
    OWDataStreamBuffer *savedBuffer;
}

+ (void)setDefaultStringEncoding:(NSStringEncoding)aStringEncoding;

- init;
- initWithLength:(unsigned int)newLength;

- newCursor;
    // Returns a new OWDataStreamCursor.

- (void)writeData:(NSData *)newData;
- (void)writeString:(NSString *)string;
- (void)writeFormat:(NSString *)formatString, ...;

- (NSData *)bufferedData;
- (unsigned int)bufferedDataLength;

- (unsigned int)dataLength;
- (BOOL)knowsDataLength;

- (BOOL)getBytes:(void *)buffer range:(NSRange)range;
    // Returns NO if there isn't enough data for the range requested
- (NSData *)dataWithRange:(NSRange)range;
    // Returns nil if there isn't enough data for the range requested

- (BOOL)waitForMoreData;
- (BOOL)waitForBufferedDataLength:(unsigned int)length;
    // Returns NO if the stream ends and isn't long enough.

//

- (NSStringEncoding)stringEncoding;
- (void)setStringEncoding:(NSStringEncoding)aStringEncoding;

//

- (OWContentType *)contentEncoding;
- (OWContentType *)encodedContentType;
- (void)setContentEncoding:(OWContentType *)aContentEncoding;
- (void)setContentTypeAndEncodingFromFilename:(NSString *)aFilename;
- (NSString *)pathExtensionForContentTypeAndEncoding;
- (BOOL)resetContentTypeAndEncoding;
    // Can only reset once.  After that, returns NO and does nothing.

//

- (BOOL)pipeToFilename:(NSString *)aFilename contentCache:(OWContentCache *)cache;
    // Returns YES if data is piped to aFilename, returns NO if data is saved to disk, but to some other filename (use -filename to find out where).  Raises an exception if it can't save.
- (NSString *)filename;
- (BOOL)hasThrownAwayData;

@end

#import "FrameworkDefines.h"

OWF_EXTERN unsigned int OWDataStreamUnknownLength;
